/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.Action;
import beaver.comp.State;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.Terminal;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

class ParsingTables {
    public final State first_state;
    final int n_term;
    short[] actions;
    short[] lookaheads;
    int[] terminal_offsets;
    int[] nonterminal_offsets;
    int last_action_index;
    short[] default_actions;
    boolean compressed;
    static final int UNUSED_OFFSET = Integer.MIN_VALUE;

    ParsingTables(Grammar grammar, State first_state) {
        int num_states = ParsingTables.countStates(first_state);
        this.first_state = first_state;
        this.n_term = grammar.terminals.length;
        this.default_actions = new short[num_states + 1];
        this.terminal_offsets = new int[num_states + 1];
        this.nonterminal_offsets = new int[num_states + 1];
        Arrays.fill(this.terminal_offsets, Integer.MIN_VALUE);
        Arrays.fill(this.nonterminal_offsets, Integer.MIN_VALUE);
        this.actions = new short[16384];
        this.lookaheads = new short[this.actions.length];
        Arrays.fill(this.lookaheads, (short)-1);
        ArrayList<Action.List> list_of_action_lists = new ArrayList<Action.List>(num_states * 2);
        State state = first_state;
        while (state != null) {
            if (state.default_action != null) {
                this.default_actions[state.id] = state.default_action.getId();
                this.compressed = true;
            }
            if (state.terminal_lookahead_actions.num_actions > 0) {
                list_of_action_lists.add(state.terminal_lookahead_actions);
            }
            if (state.nonterminal_lookahead_actions.num_actions > 0) {
                list_of_action_lists.add(state.nonterminal_lookahead_actions);
            }
            state = state.next;
        }
        Action.List[] action_lists = list_of_action_lists.toArray(new Action.List[list_of_action_lists.size()]);
        Arrays.sort(action_lists, Action.List.NUM_ACTIONS_CMP);
        this.renumberSymbols(grammar, action_lists);
        int start_index = 0;
        int i = 0;
        while (i < action_lists.length) {
            Action.List list = action_lists[i];
            int offset = this.findOffset(list, start_index);
            if (list.first.lookahead instanceof Terminal) {
                if (this.terminal_offsets[list.state.id] != Integer.MIN_VALUE) {
                    throw new IllegalStateException("terminal offset " + list.state.id + " is used");
                }
                this.terminal_offsets[list.state.id] = offset;
            } else {
                if (this.nonterminal_offsets[list.state.id] != Integer.MIN_VALUE) {
                    throw new IllegalStateException("nonterminal offset " + list.state.id + " is used");
                }
                this.nonterminal_offsets[list.state.id] = offset;
            }
            this.last_action_index = Math.max(this.last_action_index, offset + list.last.lookahead.id);
            start_index = this.advanceStartIndex(start_index);
            ++i;
        }
    }

    private void renumberSymbols(Grammar grammar, Action.List[] action_lists) {
        int i = 0;
        while (i < action_lists.length) {
            Action act = action_lists[i].first;
            while (act != null) {
                ++act.lookahead.nrefs;
                act = act.next;
            }
            ++i;
        }
        Arrays.sort(grammar.terminals, 1, grammar.terminals.length, GrammarSymbol.NUMBER_OF_REFERENCES_COMPARATOR);
        Arrays.sort(grammar.nonterminals, GrammarSymbol.NUMBER_OF_REFERENCES_COMPARATOR);
        i = 1;
        while (i < grammar.terminals.length) {
            grammar.terminals[i].id = (short)i;
            ++i;
        }
        i = 0;
        while (i < grammar.nonterminals.length) {
            grammar.nonterminals[i].id = (short)(i + grammar.terminals.length);
            ++i;
        }
        i = 0;
        while (i < action_lists.length) {
            action_lists[i].sort();
            ++i;
        }
    }

    private int advanceStartIndex(int start_index) {
        while (start_index < this.actions.length && this.actions[start_index] != 0) {
            ++start_index;
        }
        return start_index;
    }

    private int findOffset(Action.List action_list, int start_index) {
        short min_lookahead_id = action_list.first.lookahead.id;
        short max_lookahead_id = action_list.last.lookahead.id;
        int range = max_lookahead_id - min_lookahead_id + 1;
        while (true) {
            int last_index = this.actions.length - range;
            int index = start_index;
            while (index <= last_index) {
                int offset;
                if (this.actions[index] == 0 && this.tryInsertActions(action_list, offset = index - min_lookahead_id)) {
                    this.insertActions(action_list, offset);
                    return offset;
                }
                ++index;
            }
            if (this.actions.length >= 0x100000) {
                throw new IllegalStateException("cannot find place for some actions in parsing tables");
            }
            this.actions = ParsingTables.expand(this.actions);
            int len = this.lookaheads.length;
            this.lookaheads = ParsingTables.expand(this.lookaheads);
            Arrays.fill(this.lookaheads, len, this.lookaheads.length, (short)-1);
        }
    }

    private void insertActions(Action.List action_list, int offset) {
        Action act = action_list.first;
        while (act != null) {
            int index = offset + act.lookahead.id;
            if (this.actions[index] != 0) {
                throw new IllegalStateException("inserting action in occupied slot");
            }
            this.actions[index] = act.getId();
            act = act.next;
        }
    }

    private boolean tryInsertActions(Action.List action_list, int offset) {
        if (this.canInsertActions(action_list, offset)) {
            this.insertLookaheads(action_list, offset);
            if (action_list.first.lookahead.id >= this.n_term || !this.hasCollisions()) {
                return true;
            }
            this.removeLookaheads(action_list, offset);
        }
        return false;
    }

    private boolean canInsertActions(Action.List action_list, int offset) {
        Action act = action_list.first;
        while (act != null) {
            if (this.actions[offset + act.lookahead.id] != 0) {
                return false;
            }
            act = act.next;
        }
        return true;
    }

    private void insertLookaheads(Action.List action_list, int offset) {
        Action act = action_list.first;
        while (act != null) {
            int index = offset + act.lookahead.id;
            if (this.lookaheads[index] >= 0) {
                throw new IllegalStateException("lookahead collision during initial insert");
            }
            this.lookaheads[index] = act.lookahead.id;
            act = act.next;
        }
    }

    private void removeLookaheads(Action.List action_list, int offset) {
        Action act = action_list.first;
        while (act != null) {
            this.lookaheads[offset + act.lookahead.id] = -1;
            act = act.next;
        }
    }

    private boolean hasCollisions() {
        State state = this.first_state;
        while (state != null) {
            int offset = this.terminal_offsets[state.id];
            if (offset != Integer.MIN_VALUE) {
                Action act = state.terminal_lookahead_actions.first;
                int la = 0;
                while (la < this.n_term) {
                    if (act != null && act.lookahead.id == la) {
                        act = act.next;
                    } else {
                        int index = offset + la;
                        if (index >= 0 && index < this.lookaheads.length && this.lookaheads[index] == la) {
                            return true;
                        }
                    }
                    ++la;
                }
            }
            state = state.next;
        }
        return false;
    }

    void writeTo(DataOutputStream data_stream) throws IOException {
        int len = this.last_action_index + 1;
        data_stream.writeInt(len);
        int i = 0;
        while (i < len) {
            data_stream.writeShort(this.actions[i]);
            ++i;
        }
        i = 0;
        while (i < len) {
            data_stream.writeShort(this.lookaheads[i]);
            ++i;
        }
        len = this.terminal_offsets.length;
        data_stream.writeInt(len);
        i = 0;
        while (i < len) {
            data_stream.writeInt(this.terminal_offsets[i]);
            ++i;
        }
        i = 0;
        while (i < len) {
            data_stream.writeInt(this.nonterminal_offsets[i]);
            ++i;
        }
        data_stream.writeInt(this.compressed ? len : (len = 0));
        i = 0;
        while (i < len) {
            data_stream.writeShort(this.default_actions[i]);
            ++i;
        }
    }

    static int countStates(State state) {
        while (state.next != null) {
            state = state.next;
        }
        return state.id;
    }

    static short[] expand(short[] array) {
        short[] temp = new short[array.length * 2];
        System.arraycopy(array, 0, temp, 0, array.length);
        return temp;
    }
}

