/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex.fsm;

import java.util.BitSet;
import metalexer.jflex.fsm.NFA;

public class ENFA {
    private final int numStates;
    private final int numSymbols;
    private final BitSet[][] transitions;
    private final BitSet[] epsilons;
    private final Integer[] actions;

    public ENFA(BitSet[][] bitSetArray, BitSet[] bitSetArray2, Integer[] integerArray) {
        this.numStates = bitSetArray.length;
        this.numSymbols = bitSetArray[0].length;
        this.transitions = bitSetArray;
        this.epsilons = bitSetArray2;
        this.actions = integerArray;
    }

    public NFA convertToNFA() {
        BitSet[] bitSetArray = new BitSet[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            bitSetArray[i] = this.buildEpsilonClosure(i);
        }
        BitSet[][] bitSetArray2 = new BitSet[this.numStates][this.numSymbols];
        for (int i = 0; i < this.numStates; ++i) {
            for (int j = 0; j < this.numSymbols; ++j) {
                BitSet bitSet = bitSetArray[i];
                BitSet bitSet2 = new BitSet(this.numStates);
                for (int k = 0; k < this.numStates; ++k) {
                    if (!bitSet.get(k)) continue;
                    bitSet2.or(this.transitions[k][j]);
                }
                bitSetArray2[i][j] = bitSet2 = this.epsilonClosure(bitSet2, bitSetArray);
            }
        }
        return new NFA(bitSetArray2, this.actions);
    }

    private BitSet buildEpsilonClosure(int n) {
        BitSet bitSet = new BitSet();
        bitSet.set(n);
        BitSet bitSet2;
        while (!(bitSet2 = this.buildEpsilonClosureStep(bitSet)).equals(bitSet)) {
            bitSet = bitSet2;
        }
        return bitSet;
    }

    private BitSet buildEpsilonClosureStep(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        bitSet2.or(bitSet);
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            bitSet2.or(this.epsilons[i]);
        }
        return bitSet2;
    }

    private BitSet epsilonClosure(BitSet bitSet, BitSet[] bitSetArray) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            bitSet2.or(bitSetArray[i]);
        }
        return bitSet2;
    }
}

