/*
 * Decompiled with CFR 0.152.
 */
package jastadd;

import jastadd.JastAdd;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JastAddTask
extends Task {
    private LinkedHashSet files = new LinkedHashSet();
    private boolean jjtree = false;
    private String grammar = null;
    private boolean beaver = false;
    private String packageName = null;
    private String outdir = null;
    private String defaultMap = null;
    private String defaultSet = null;
    private boolean lazyMaps = true;
    private boolean rewrite = false;
    private boolean novisitcheck = false;
    private boolean noCacheCycle = false;
    private boolean noComponentCheck = true;
    private boolean noInhEqCheck = false;
    private boolean suppressWarnings = false;
    private boolean parentInterface = false;
    private boolean doc = false;
    private String license = null;
    private boolean java14 = false;
    private boolean debug = false;
    private boolean synch = false;
    private boolean noStatic = false;
    private boolean refineLegacy = true;
    private boolean stagedRewrites = false;

    public void init() {
        super.init();
    }

    public void addConfiguredFileSet(FileSet fileset) {
        DirectoryScanner s = fileset.getDirectoryScanner(this.getProject());
        String[] files = s.getIncludedFiles();
        String baseDir = s.getBasedir().getPath();
        int i = 0;
        while (i < files.length) {
            this.files.add(String.valueOf(baseDir) + File.separator + files[i]);
            ++i;
        }
    }

    public void setJjtree(boolean b) {
        this.jjtree = b;
    }

    public void setGrammar(String g) {
        this.grammar = g;
    }

    public void setBeaver(boolean b) {
        this.beaver = b;
    }

    public void setPackage(String name) {
        this.packageName = name;
    }

    public void setOutdir(String dir) {
        this.outdir = dir;
    }

    public void setDefaultMap(String map) {
        this.defaultMap = map;
    }

    public void setDefaultSet(String set) {
        this.defaultSet = set;
    }

    public void setLazyMaps(boolean b) {
        this.lazyMaps = b;
    }

    public void setRewrite(boolean b) {
        this.rewrite = b;
    }

    public void setNovisitcheck(boolean b) {
        this.novisitcheck = b;
    }

    public void setNoCacheCycle(boolean b) {
        this.noCacheCycle = b;
    }

    public void setNoComponentCheck(boolean b) {
        this.noComponentCheck = b;
    }

    public void setComponentCheck(boolean b) {
        this.noComponentCheck = !b;
    }

    public void setNoInhEqCheck(boolean b) {
        this.noInhEqCheck = b;
    }

    public void setSuppressWarnings(boolean b) {
        this.suppressWarnings = b;
    }

    public void setParentInterface(boolean b) {
        this.parentInterface = b;
    }

    public void setDoc(boolean b) {
        this.doc = b;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setJava14(boolean b) {
        this.java14 = b;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void setSynch(boolean b) {
        this.synch = b;
    }

    public void setNoStatic(boolean b) {
        this.noStatic = b;
    }

    public void setRefineLegacy(boolean b) {
        this.refineLegacy = b;
    }

    public void setStagedRewrites(boolean b) {
        this.stagedRewrites = b;
    }

    public void execute() throws BuildException {
        if (this.jjtree && this.grammar == null) {
            throw new BuildException("JJTree option requires grammar to be set");
        }
        if (this.jjtree && this.beaver) {
            throw new BuildException("Can not generate AST for both JJTree and Beaver");
        }
        if (this.files.size() == 0) {
            throw new BuildException("JastAdd requires grammar and aspect files");
        }
        StringBuffer name = new StringBuffer();
        if (this.outdir != null) {
            name.append(this.outdir);
            if (!this.outdir.endsWith(File.separator)) {
                name.append(File.separator);
            }
        }
        if (this.packageName != null) {
            name.append(String.valueOf(this.packageName.replace('.', File.separatorChar)) + File.separator);
        }
        name.append("ASTNode.java");
        File generated = new File(name.toString());
        if (generated.exists()) {
            boolean changed = false;
            Iterator iter = this.files.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                File file = new File(fileName);
                if (file.exists() && file.lastModified() <= generated.lastModified()) continue;
                changed = true;
            }
            if (!changed) {
                return;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.jjtree) {
            args.add("--jjtree");
            args.add("--grammar=" + this.grammar);
        }
        if (this.beaver) {
            args.add("--beaver");
        }
        if (this.packageName != null) {
            args.add("--package=" + this.packageName);
        }
        if (this.outdir != null) {
            args.add("--o=" + this.outdir);
        }
        if (this.defaultMap != null) {
            args.add("--defaultMap=" + this.defaultMap);
        }
        if (this.defaultSet != null) {
            args.add("--defaultSet=" + this.defaultSet);
        }
        if (this.lazyMaps) {
            args.add("--lazyMaps");
        }
        if (this.rewrite) {
            args.add("--rewrite");
        }
        if (this.novisitcheck) {
            args.add("--novisitcheck");
        }
        if (this.noCacheCycle) {
            args.add("--noCacheCycle");
        }
        if (this.noComponentCheck) {
            args.add("--noComponentCheck");
        }
        if (this.noInhEqCheck) {
            args.add("--noInhEqCheck");
        }
        if (this.suppressWarnings) {
            args.add("--suppressWarnings");
        }
        if (this.parentInterface) {
            args.add("--parentInterface");
        }
        if (this.doc) {
            args.add("--doc");
        }
        if (this.debug) {
            args.add("--debug");
        }
        if (this.license != null) {
            args.add("--license=" + this.license);
        }
        if (this.java14) {
            args.add("--java1.4");
        }
        if (this.synch) {
            args.add("--synch");
        }
        if (this.noStatic) {
            args.add("--noStatic");
        }
        if (this.refineLegacy) {
            args.add("--refineLegacy");
        }
        if (this.stagedRewrites) {
            args.add("--stagedRewrites");
        }
        args.addAll(this.files);
        int i = 0;
        String[] argsArray = new String[args.size()];
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            argsArray[i] = ((String)iter.next()).trim();
            ++i;
        }
        System.err.println("generating node types and weaving aspects");
        JastAdd.main(argsArray);
        System.err.println("done");
    }
}

