import java.io.*;

%%

//general header info
%public
%final
%class EscapeScanner

%unicode
%function next
%type boolean

%{
    public static void main(String[] args) throws Exception {
        String filename = args[0];
        BufferedReader in = new BufferedReader(new FileReader(filename));
        EscapeScanner scanner = new EscapeScanner(in);
        while(scanner.next()) {}
        in.close();
        System.exit(0);
    }
%}

%%

\n { System.out.println("1"); return true; }
\12 { System.out.println("2"); return true; } //unreachable
\012 { System.out.println("3"); return true; } //unreachable
\uA { System.out.println("4"); return true; } //unreachable
\u0A { System.out.println("5"); return true; } //unreachable
\u00A { System.out.println("6"); return true; } //unreachable
\u000A { System.out.println("7"); return true; } //unreachable
\x0A { System.out.println("8"); return true; } //unreachable

\uAA { System.out.println("9"); return true; }
\u0AA { System.out.println("10"); return true; } //unreachable
\u00AA { System.out.println("11"); return true; } //unreachable
\u000AA { System.out.println("12"); return true; }

\
{ System.out.println("12:" + yytext()); return true; }
\\ { System.out.println("13:" + yytext()); return true; } //unreachable

\ 
{ System.out.println("14:" + yytext()); return true; }
" " { System.out.println("15:" + yytext()); return true; } //unreachable
\  { System.out.println("16:" + yytext()); return true; } //unreachable

\ { System.out.println("17:" + yytext()); return true; }
 { System.out.println("18:" + yytext()); return true; } //unreachable

\7 { System.out.println("19:" + yytext()); return true; }
7 { System.out.println("20:" + yytext()); return true; } //reachable since \7 is octal
\u7 { System.out.println("21:" + yytext()); return true; } //unreachable

"\
" { System.out.println("22:" + yytext()); return true; } //\r
\uD { System.out.println("23:" + yytext()); return true; } //unreachable

\
 { System.out.println("24:" + yytext()); return true; } //\r\n //unreachable (counts as \uD)
\uA\uD { System.out.println("25:" + yytext()); return true; } //reachable

\777 { System.out.println("26:" + yytext()); return true; }
\?7 { System.out.println("27:" + yytext()); return true; } //unreachable

. | \n {  System.out.println("ANY"); return true; }
<<EOF>> { System.out.println("EOF"); return false; }