package pi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
%%
%public
%class Meta
%function start
%type Object

%{
    java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();
    
    void saveStateAndTransition(int newState) {
        stateStack.push(yy_lexical_state);
        yybegin(newState);
    }
    
    void restoreState() {
        yybegin(stateStack.pop());
    }
%}

%{
    private Transition transition = null;
    
    private void notifyLexer(int embeddingNum) {
        this.transition = new Transition(embeddingNum, yytext());
    }
    
    public Transition checkForTransition() {
        Transition tmp = transition;
        transition = null;
        return tmp;
    }
%}

%{
    public static class Transition {
        private final int embeddingNum;
        private final String match;
        
        public Transition(int embeddingNum, String match) {
            this.embeddingNum = embeddingNum;
            this.match = match;
        }
        
        public int getEmbeddingNum() { return embeddingNum; }
        
        public String getMatch() { return match; }
    }
%}

%init{
    //Start in state BASE
    yybegin(BASE);
    
    //Transition through states reachable by pure BOF patterns
%init}

%eofval{
    return null;
%eofval}

%state BASE
%state e_embed

t_END = \u0034
t_START = \u0031


%%


<BASE> {t_START} {
    saveStateAndTransition(e_embed); notifyLexer(/*embed*/ 0);
}

<e_embed> {t_END} {
    restoreState(); notifyLexer(/*restore previous*/ -1);
}

(.|\n) {
    /*consume and ignore*/
}
