package pi;

%%

%public
%final
%class JFlexBadPiScanner
%implements PiScanner

%unicode
%function getFreqs
%type int[]

%{
    private final int[] freq = new int[10];
%}

%{
    public void stop() {}
%}

%init{
    yybegin(S0);
%init}

%s S0, S1, S2, S3, S4, S5, S6, S7, S8, S9

%%

<S0, S1, S2, S3, S4, S5, S6, S7, S8, S9> {
    0 { freq[0]++; yybegin(S1); }
    1 { freq[1]++; yybegin(S2); }
    2 { freq[2]++; yybegin(S3); }
    3 { freq[3]++; yybegin(S4); }
    4 { freq[4]++; yybegin(S5); }
    5 { freq[5]++; yybegin(S6); }
    6 { freq[6]++; yybegin(S7); }
    7 { freq[7]++; yybegin(S8); }
    8 { freq[8]++; yybegin(S9); }
    9 { freq[9]++; yybegin(S0); }
}

(.|\n) {}

<<EOF>> { return freq; }