package properties;
%%
import static properties.TokenNames.*;
%%
%layout properties

%option public "%public"
%option final "%final"
%option class "%class PropertiesLexer"
%option unicode "%unicode"
%option function "%function getNext"
%option type "%type Token"
%option pos_line "%line"
%option pos_column "%column"

%declare "Token symbol(int)"
%declare "Token symbol(int, String)"
%declare "Token symbol(int, String, int, int, int, int)"
%{
    private Token symbol(int symbolType) {
        return symbol(symbolType, null);
    }
    private Token symbol(int symbolType, String text) {
        return new Token(symbolType, text, yyline + 1, yycolumn + 1, yyline + 1, yycolumn + yylength());
    }
    private Token symbol(int symbolType, String text, int startLine, int startCol, int endLine, int endCol) {
        return new Token(symbolType, text, startLine + 1, startCol + 1, endLine + 1, endCol + 1);
    }
%}

%declare "void error(String) throws LexerException"
%{
    private void error(String msg) throws LexerException {
        throw new LexerException(msg);
    }
%}

%lexthrow "LexerException"

%component key
%component value

%start key

%%

%%embed
%name key_value
%host key
%guest value
%start ASSIGN
%end LINE_TERMINATOR