package metalexer;
%%
//TODO-AC: many of the catchall errors are recoverable - either return a bad token which will be discarded or just discard and make a note.
//based on http://jflex.de/manual.html

import static metalexer.ComponentParser.Terminals.*;
%%

%layout component

%option visibility "%public"
%option finality "%final"
%option class_name "%class ComponentScanner"

%component action
%component append_delim_region
%component append_region
%component base
%component bracket_comment
%component char_class
%component comp_options
%component comp_rules
%component decl_region
%component delete_directive
%component init_region
%component macro_defn
%component macro_invoc
%component mtok_decl
%component open_rule_group
%component repetition_spec
%component state_list
%component string_id_directive
%component string

%start base

%%

%%inherit beaver
%%inherit helper

%%embed
%name header
%host base
%guest comp_options
%start <BOF>
%end END_HEADER_SECTION

%%embed
%name rules
%host base
%guest comp_rules
%start %comp_options%
%end END_RULE_SECTION

%%embed
%name action
%host comp_rules
%guest action
%start START_ACTION
%end END_ACTION

%%embed
%name init_region
%host comp_options
%guest init_region
%start START_INIT_REGION
%end END_INIT_REGION

%%embed
%name decl_region
%host comp_options
%guest decl_region
%start START_DECL_REGION
%end END_DECL_REGION

%%embed
%name append_region
%host comp_options
%guest append_region
%start START_APPEND_REGION
%end END_APPEND_REGION

%%embed
%name append_delim_region
%host comp_options
%guest append_delim_region
%start START_APPEND_DELIM_REGION
%end END_APPEND_DELIM_REGION

%%embed
%name macro_defn
%host comp_options
%guest macro_defn
%start START_MACRO_DEFN
%end END_MACRO_DEFN

%%embed
%name bracket_comment
%host comp_options, macro_defn, comp_rules, mtok_decl, state_list, string_id_directive, delete_directive, open_rule_group
%host bracket_comment //NB: host and guest => nestable
%guest bracket_comment
%start START_BRACKET_COMMENT
%end END_BRACKET_COMMENT

%%embed
%name char_class
%host macro_defn, comp_rules, delete_directive
%guest char_class
%start START_CHAR_CLASS
%end END_CHAR_CLASS

%%embed
%name delete_directive
%host comp_rules
%guest delete_directive
%start START_DELETE_DIRECTIVE
%end END_DELETE_DIRECTIVE

%%embed
%name macro_invoc
%host macro_defn, comp_rules, delete_directive
%guest macro_invoc
%start START_MACRO_INVOC
%end END_MACRO_INVOC

%%embed
%name repetition_spec
%host macro_defn, comp_rules, delete_directive
%guest repetition_spec
%start START_REP_SPEC
%end END_REP_SPEC

%%embed
%name mtok_decl
%host comp_rules
%guest mtok_decl
%start %action%
%end END_MTOK_DECL

%%embed
%name string_id_directive
%host comp_options, comp_rules
%guest string_id_directive
%start START_STRING_ID_DIRECTIVE
%end END_STRING_ID_DIRECTIVE

%%embed
%name string
%host macro_defn, comp_rules, delete_directive, string_id_directive
%guest string
%start START_STRING
%end END_STRING

%%embed
%name state_list
%host comp_rules, delete_directive
%guest state_list
%start START_STATE_LIST
%end END_STATE_LIST

%%embed
%name delete_state_list
%host delete_directive
%guest state_list
%start START_STATE_LIST
%end END_STATE_LIST

%%embed
%name open_rule_group
%host comp_rules
%guest open_rule_group
%start %state_list%
%end END_OPEN_RULE_GROUP

%%embed
%name eof_error
%host action, append_delim_region, append_region, bracket_comment, char_class
%host decl_region, init_region, macro_invoc, open_rule_group, repetition_spec
%host state_list, string
%guest base
%start EOF_ERROR
%end <ANY> //NB: will never happen
