package metalexer;
%%
//TODO-AC: many of the catchall errors are recoverable - either return a bad token which will be discarded or just discard and make a note.
//TODO-AC: meta-pattern macros?
//based on http://jflex.de/manual.html

import static metalexer.LayoutParser.Terminals.*;
%%

%layout layout

%option visibility "%public"
%option finality "%final"
%option class_name "%class LayoutScanner"

%component base
%component bracket_comment
%component decl_region
%component init_region
%component layout_inherited_header
%component layout_local_header
%component layout_options
%component layout_rules
%component mpat_directive
%component pair_directive
%component string_id_directive
%component string

%start base

%%

%%inherit beaver
%%inherit helper

%%embed
%name local_header
%host base
%guest layout_local_header
%start <BOF>
%end END_LOCAL_HEADER

%%embed
%name inherited_header
%host base
%guest layout_inherited_header
%start %layout_local_header%
%end END_INHERITED_HEADER

%%embed
%name options_section
%host base
%guest layout_options
%start %layout_inherited_header%
%end END_OPTION_SECTION

%%embed
%name rules_section
%host base
%guest layout_rules
%start %layout_options%
%end END_RULES_SECTION

%%embed
%name bracket_comments
%host layout_options, layout_rules, string_id_directive, mpat_directive, pair_directive
%host bracket_comment //NB: host and guest => nestable
%guest bracket_comment
%start START_BRACKET_COMMENT
%end END_BRACKET_COMMENT

%%embed
%name init_region
%host layout_options
%guest init_region
%start START_INIT_REGION
%end END_INIT_REGION

%%embed
%name decl_region
%host layout_options
%guest decl_region
%start START_DECL_REGION
%end END_DECL_REGION

%%embed
%name string_id_directive
%host layout_options, layout_rules
%guest string_id_directive
%start START_STRING_ID_DIRECTIVE
%end END_STRING_ID_DIRECTIVE

%%embed
%name pair_directive
%host layout_rules
%guest pair_directive
%start START_PAIR_DIRECTIVE
%end END_PAIR_DIRECTIVE

%%embed
%name mpat_directive
%host layout_rules
%guest mpat_directive
%start START_MPAT_DIRECTIVE
%end END_MPAT_DIRECTIVE

%%embed
%name string
%host string_id_directive
%guest string
%start START_STRING
%end END_STRING

%%embed
%name eof_error
%host bracket_comment, decl_region, init_region, layout_inherited_header, layout_local_header, string
%guest base
%start EOF_ERROR
%end <ANY> //NB: will never happen