package metalexer;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class ProblemUtil {
    private ProblemUtil() {}

    public static List<CompilationError> extractErrors(List<CompilationProblem> problems) {
        List<CompilationError> errors = new ArrayList<CompilationError>();
        for(CompilationProblem problem : problems) {
            if(problem instanceof CompilationError) {
                errors.add((CompilationError) problem);
            }
        }
        return errors;
    }

    public static SortedSet<CompilationError> extractErrors(SortedSet<CompilationProblem> problems) {
        SortedSet<CompilationError> errors = new TreeSet<CompilationError>();
        for(CompilationProblem problem : problems) {
            if(problem instanceof CompilationError) {
                errors.add((CompilationError) problem);
            }
        }
        return errors;
    }

    public static List<CompilationWarning> extractWarnings(List<CompilationProblem> problems) {
        List<CompilationWarning> warnings = new ArrayList<CompilationWarning>();
        for(CompilationProblem problem : problems) {
            if(problem instanceof CompilationWarning) {
                warnings.add((CompilationWarning) problem);
            }
        }
        return warnings;
    }

    public static SortedSet<CompilationWarning> extractWarnings(SortedSet<CompilationProblem> problems) {
        SortedSet<CompilationWarning> warnings = new TreeSet<CompilationWarning>();
        for(CompilationProblem problem : problems) {
            if(problem instanceof CompilationWarning) {
                warnings.add((CompilationWarning) problem);
            }
        }
        return warnings;
    }
}
