package metalexer;

import metalexer.ast.ASTNode;
import beaver.Symbol;

public class StringSymbol extends ASTNode<ASTNode> {
    private String text;
    
    public StringSymbol(Symbol posSymbol, String text) {
        this(posSymbol.getStart(), posSymbol.getEnd(), text);
    }
    
    public StringSymbol(int start, int end, String text) {
        this.start = start;
        this.end = end;
        this.text = text;
    }

    public String getText() {
        return text;
    }

    @Override
    //NB: doesn't consider position
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getText() == null) ? 0 : getText().hashCode());
        return result;
    }

    @Override
    //NB: doesn't consider position
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final StringSymbol other = (StringSymbol) obj;
        if (getText() == null) {
            if (other.getText() != null)
                return false;
        } else if (!getText().equals(other.getText()))
            return false;
        return true;
    }
}
