package metalexer.jflex;

import java.io.IOException;
import java.io.PrintWriter;

import metalexer.AbstractTestGenerator;

public class ComponentMetaScannerTestGenerator extends AbstractTestGenerator {
    protected ComponentMetaScannerTestGenerator() {
        super("/metalexer/jflex/ComponentMetaScannerTests.java");
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer.jflex;");
        testFileWriter.println();
        testFileWriter.println("import java.util.List;");
        testFileWriter.println();
        testFileWriter.println("public class ComponentMetaScannerTests extends MetaScannerTestBase {");
        testFileWriter.println();
        
        testFileWriter.println("    public ComponentMetaScannerTests() {");
        testFileWriter.println("        super(\"metalexer\", \"component\");");
        testFileWriter.println("    }");
        testFileWriter.println();

        testFileWriter.println("    protected List<List<Integer>> getActualOutput(List<Integer> input) {");
        testFileWriter.println("        return ComponentMetaScannerTestTool.getActualOutput(input);");
        testFileWriter.println("    }");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        testFileWriter.println();
        testFileWriter.println("    public void " + methodName + "() throws Exception {");
        testFileWriter.println("        checkOutput(\"" + testName + "\");");
        testFileWriter.println("    }");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
    
    public static void main(String[] args) throws IOException {
        new ComponentMetaScannerTestGenerator().generate(args);
    }
}
