package metalexer.jflex;

import java.io.IOException;
import java.io.Reader;

import metalexer.ScannerTestTool;
import test.jflex.metalexer.ComponentParser;
import beaver.Scanner;

public class ComponentScannerTestTool extends ScannerTestTool {
    private ComponentScannerTestTool() {
        super(ComponentParser.Terminals.EOF, ComponentParser.Terminals.NAMES);
    }

    protected Scanner makeScanner(Reader in) {
        return ReflectionHelper.instantiateScanner("test.jflex.metalexer.ComponentScanner", in);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.jflex.ComponentScannerTestTool {basename}");
            System.exit(1);
        }
        try {
            new ComponentScannerTestTool().processFile(args[0]);
            System.exit(0);
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}
