package metalexer.jflex;

import java.io.PrintWriter;

import metalexer.AbstractTestGenerator;

/** Generates metalexer.*ErrotTests from the provided list file. */
public abstract class ErrorTestGenerator extends AbstractTestGenerator {
    private final String prefix;

    protected ErrorTestGenerator(String prefix) {
        super("/metalexer/jflex/" + prefix + "ErrorTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer.jflex;");
        testFileWriter.println();
        testFileWriter.println("import java.util.List;");
        testFileWriter.println("import java.util.SortedSet;");
        testFileWriter.println("import java.util.TreeSet;");
        testFileWriter.println();
        testFileWriter.println("import metalexer.*;");
        testFileWriter.println("import metalexer.ast.*;");
        testFileWriter.println();
        testFileWriter.println("public class " + prefix + "ErrorTests extends " + prefix + "ParserFailTestBase {");
        //NB: not a typo - do extend ParserFailTestBase
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String outFileName = "test/backend-jflex/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("    public void " + methodName + "() throws Exception {");
        testFileWriter.println("        FileLoader loader = new FileLoader(\"test/backend-jflex\");");
        testFileWriter.println("        SortedSet<CompilationProblem> actualErrors = new TreeSet<CompilationProblem>();");
        testFileWriter.println("        " + prefix + " node = loader.load" + prefix + "(\"" + testName + "\", actualErrors);");
        testFileWriter.println("        assertTrue(node.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        node = node.processInheritance(loader, actualErrors);");
        testFileWriter.println("        assertTrue(node.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        List<String> expectedErrors = readErrors(\"" + outFileName + "\");");
        testFileWriter.println("        assertEquals(expectedErrors, metalexer.ProblemUtil.extractErrors(actualErrors));");
        testFileWriter.println("    }");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}
