package metalexer.jflex;

import java.io.IOException;
import java.io.Reader;

import metalexer.ScannerTestTool;
import test.jflex.natlab.NatlabParser;
import beaver.Scanner;

public class NaiveNatlabScannerTestTool extends ScannerTestTool {
    private NaiveNatlabScannerTestTool() {
        super(NatlabParser.Terminals.EOF, NatlabParser.Terminals.NAMES);
    }

    protected Scanner makeScanner(Reader in) {
        return ReflectionHelper.instantiateScanner("test.jflex.natlab.NaiveNatlabScanner", in);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.jflex.NaiveNatlabScannerTestTool {basename}");
            System.exit(1);
        }
        try {
            new NaiveNatlabScannerTestTool().processFile(args[0]);
            System.exit(0);
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}
