package metalexer.jflex;

import junit.framework.TestCase;

public class PackageFindTests extends TestCase {
    public void testSingleLineComments() {
        checkPackage("//package x;", null);
        checkPackage("package x;\n//package y;", "x");
        checkPackage("//package x;\npackage y;", "y");
        checkPackage("package x;\n//package y;\npackage z;", "z");
    }

    public void testMultiLineComments() {
        checkPackage("/*package x;*/", null);
        checkPackage("package x;\n/*package y;*/", "x");
        checkPackage("/*package x;*/\npackage y;", "y");
        checkPackage("package x;\n/*package y;*/\npackage z;", "z");
    }

    public void testNestedComments() {
        checkPackage("/*package x; /*package y;*/*/", null);
        checkPackage("/*/*package x;*/ package y;*/", null);
        checkPackage("/*/*package x;*/*/ package y;", "y");
    }

    public void testStrings() {
        checkPackage("\"package x;\"", null);
        checkPackage("package x;\n\"package y;\"", "x");
        checkPackage("\"package x;\"\npackage y;", "y");
        checkPackage("package x;\n\"package y;\"\npackage z;", "z");
    }

    public void testStringsWithEscapes() {
        checkPackage("\"package \\\"x\\\";\"", null);
    }

    public void testEmptyPackage() {
        checkPackage("package;", null);
    }

    public void testMalformed() {
        checkPackage("package x", "x");
        checkPackage("package", null);
        checkPackage("package ", null);
        checkPackage("/*package", null);
        checkPackage("/*/*package*/", null);
        checkPackage("/*/*package", null);
        checkPackage("//package x", null);
        checkPackage("/package x", "x");
        checkPackage("asdjf;ilai package x; ahdfkd; fas", "x");
        checkPackage("\"package x\\\";\"", null);
        checkPackage("\"package x", null);
    }

    public void testIdentifier() {
        checkPackage("package1 x;", null);
    }

    public void testCommentInPackage() {
        checkPackage("package x//\n;", "x");
        checkPackage("package /* */ x\n;", "x");
        
        checkPackage("package x//;\n;", "x");
        checkPackage("package x/*;*/\n;", "x");
        
        checkPackage("package//\n x\n;", "x");
        checkPackage("package/* */ x\n;", "x");
    }

    private static void checkPackage(String original, String expected) {
        assertEquals("Package: ", expected, PackageFind.findPackage(original));
    }
}
