package metalexer.jflex;

import java.io.PrintWriter;

import metalexer.AbstractTestGenerator;

/** Generates metalexer.*ScannerTests from the provided list file. */
public abstract class ScannerTestGenerator extends AbstractTestGenerator {
    protected final String prefix;
    protected final String baseDir;

    protected ScannerTestGenerator(String prefix, String baseDir) {
        super("/metalexer/jflex/" + prefix + "ScannerTests.java");
        this.prefix = prefix;
        this.baseDir = baseDir;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer.jflex;");
        testFileWriter.println();
        testFileWriter.println("import java.util.ArrayList;");
        testFileWriter.println("import java.util.List;");
        testFileWriter.println();
        testFileWriter.println("import beaver.Scanner;");
        testFileWriter.println("import beaver.Symbol;");
        testFileWriter.println();
        testFileWriter.println("public class " + prefix + "ScannerTests extends " + prefix + "ScannerTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String inFileName = baseDir + "/" + testName + ".in";
        String outFileName = baseDir + "/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("	public void " + methodName + "() throws Exception {");
        testFileWriter.println("		Scanner scanner = getScanner(\"" + inFileName + "\");");
        testFileWriter.println("		List<Symbol> symbols = new ArrayList<Symbol>();");
        testFileWriter.println("		Scanner.Exception exception = parseSymbols(\"" + outFileName + "\", symbols);");
        testFileWriter.println("		checkScan(scanner, symbols, exception);");
        testFileWriter.println("	}");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}
