package metalexer.jflex;

import junit.framework.TestCase;

public class StringEscapeTests extends TestCase {
    public void testUEscapes() {
        checkEscape("\\u1", "\\u0001");
        checkEscape("\\u10", "\\u0010");
        checkEscape("\\u100", "\\u0100");
        checkEscape("\\u1000", "\\u1000");
    }

    public void testXEscapes() {
        checkEscape("\\x01", "\\x01");
    }

    public void testOctalEscapes() {
        checkEscape("\\1", "\\001");
        checkEscape("\\10", "\\010");
        checkEscape("\\100", "\\100");
    }

    public void testLineEndingEscapes() {
        checkEscape("\n", "\\n");
        checkEscape("\r", "\\r");
        checkEscape("\\\n", "\\n");
        checkEscape("\\\r", "\\r");
    }

    public void testTraditionalEscapes() {
        //traditional
        checkEscape("\\n", "\\n");
        checkEscape("\\r", "\\r");
        checkEscape("\\t", "\\t");
        checkEscape("\\f", "\\f");
        checkEscape("\\b", "\\b");
    }

    public void testMetaEscapes() {
        checkEscape("\\\\", "\\\\");
        checkEscape("\\|", "\\|");
        checkEscape("\\(", "\\(");
        checkEscape("\\)", "\\)");
        checkEscape("\\{", "\\{");
        checkEscape("\\}", "\\}");
        checkEscape("\\[", "\\[");
        checkEscape("\\]", "\\]");
        checkEscape("\\<", "\\<");
        checkEscape("\\>", "\\>");
        checkEscape("\\.", "\\.");
        checkEscape("\\*", "\\*");
        checkEscape("\\+", "\\+");
        checkEscape("\\?", "\\?");
        checkEscape("\\^", "\\^");
        checkEscape("\\$", "\\$");
        checkEscape("\\/", "\\/");
        checkEscape("\\\"", "\\\"");
        checkEscape("\\~", "\\~");
        checkEscape("\\!", "\\!");
        checkEscape("\\-", "\\-");
    }

    public void testOtherEscapes() {
        checkEscape("\\a", "\\a");
        checkEscape("\\q", "\\q");
    }

    public void testDoubleEscapes() {
        checkEscape("\\\\u1", "\\\\u1");
        checkEscape("\\\\1", "\\\\1");
        checkEscape("\\\\\n", "\\\\\\n");
    }

    private static void checkEscape(String original, String expected) {
        assertEquals("Escaping: ", expected, StringEscape.escapeString(original));
    }
}
