//based on http://jflex.de/manual.html

package metalexer;
%%
import static metalexer.LayoutParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

%layout layout

%start base

%component base
%component bracket_comment
%component decl_region
%component identifier_directive
%component inherited_header
%component init_region
%component layout_option_section
%component layout_rule_section
%component local_header
%component metapattern_directive
%component string
%component string_directive

%option visibility "%public"
%option final "%final"
%option class "%class LayoutScanner"
%option extends "%extends Scanner"
%option encoding "%unicode"
%option function "%function nextToken"
%option type "%type Symbol"
%option line "%line"
%option col "%column"

%declare "Symbol symbol(short)"
%declare "Symbol symbol(short, Object)"
%declare "Symbol symbol(short, Object, int, int, int, int)"
%declare "void error(String) throws Scanner.Exception"
%declare "void error(String, int) throws Scanner.Exception"

%lexthrow "Scanner.Exception"

%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}

%%

%%embed
%name local_header_section
%host base
%guest local_header
%start <BOF>
%end END_LOCAL_HEADER

%%embed
%name inherited_header_section
%host base
%guest inherited_header
%start %local_header%
%end END_INHERITED_HEADER

%%embed
%name option_section
%host base
%guest layout_option_section
%start %inherited_header%
%end END_OPTION_SECTION

%%embed
%name option_decl
%host layout_option_section
%guest decl_region
%start START_DECL_REGION
%end END_DECL_REGION

%%embed
%name option_init
%host layout_option_section
%guest init_region
%start START_INIT_REGION
%end END_INIT_REGION

%%embed
%name option_string_directive
%host layout_option_section
%guest string_directive
%start START_STRING_DIRECTIVE
%end END_STRING_DIRECTIVE

%%embed
%name rule_section
%host base
%guest layout_rule_section
%start %layout_option_section%
%end END_RULE_SECTION

%%embed
%name metapattern_directive
%host layout_rule_section
%guest metapattern_directive
%start START_METAPATTERN_DIRECTIVE
%end END_METAPATTERN_DIRECTIVE

%%embed
%name comments
%host layout_option_section
%host layout_rule_section
%host identifier_directive
%host string_directive
%host metapattern_directive
%host bracket_comment
%guest bracket_comment
%start START_BRACKET_COMMENT
%end END_BRACKET_COMMENT

%%embed
%name identifier_directive
%host layout_option_section
%host layout_rule_section
%guest identifier_directive
%start START_IDENTIFIER_DIRECTIVE
%end END_IDENTIFIER_DIRECTIVE

%%embed
%name string
%host string_directive
%guest string
%start START_STRING
%end END_STRING

