package metalexer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;

import junit.framework.TestCase;
import beaver.Scanner;

/** 
 * Parent class of the generated ComponentParserFailTests class.
 * Provides helper methods to keep ComponentParserFailTests short.
 */
abstract class ParserFailTestBase extends TestCase {

    /* Construct a scanner that will read from the specified file. */
    abstract protected Scanner getScanner(String filename) throws FileNotFoundException;

    /* Read a list of errors from the .out file - one per line. */
    protected static List<String> readErrors(String filename) throws IOException {
        List<String> errors = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while(in.ready()) {
            errors.add(in.readLine());
        }
        in.close();
        return errors;
    }

    protected static void assertEquals(List<String> expectedErrors, SortedSet<? extends CompilationProblem> actualErrors) {
        if(expectedErrors == null) {
            assertNull(actualErrors);
        } else {
            assertNotNull(actualErrors);
            assertEquals(expectedErrors.size(), actualErrors.size());
            List<CompilationProblem> actualErrorList = new ArrayList<CompilationProblem>(actualErrors);
            for(int i = 0; i < expectedErrors.size(); i++) {
                assertEquals(expectedErrors.get(i), ScannerUtil.stringifyValue(actualErrorList.get(i).toString()));
            }
        }
    }
}
