package metalexer;

import java.io.PrintWriter;

/** Generates metalexer.*ScannerTests from the provided list file. */
public abstract class ScannerTestGenerator extends AbstractTestGenerator {
    private final String prefix;

    protected ScannerTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "ScannerTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import java.util.ArrayList;");
        testFileWriter.println("import java.util.List;");
        testFileWriter.println();
        testFileWriter.println("import beaver.Scanner;");
        testFileWriter.println("import beaver.Symbol;");
        testFileWriter.println();
        testFileWriter.println("public class " + prefix + "ScannerTests extends " + prefix + "ScannerTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String inFileName = "test/frontend/" + testName + ".in";
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("	public void " + methodName + "() throws Exception {");
        testFileWriter.println("		Scanner scanner = getScanner(\"" + inFileName + "\");");
        testFileWriter.println("		List<Symbol> symbols = new ArrayList<Symbol>();");
        testFileWriter.println("		Scanner.Exception exception = parseSymbols(\"" + outFileName + "\", symbols);");
        testFileWriter.println("		checkScan(scanner, symbols, exception);");
        testFileWriter.println("	}");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}
