package metalexer.jflex;

import java.io.IOException;
import java.io.StringReader;

%%

//general header info
%public
%final
%class ReturnWrap

%unicode
%function process
%type String

%{
    private StringBuffer buf = new StringBuffer();
%}

%{
    public static String wrapReturns(String original) {
        StringReader reader = new StringReader(original);
        ReturnWrap scanner = new ReturnWrap(reader);
        String result = null;
        try {
            result = scanner.process();
            reader.close();
        } catch(IOException e) {
            //can't happen since StringReader
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }
%}

%{
    private int depth = 0;
    private boolean lookingForSemi = false;
%}

Any = . | \n

StartSLC = "//"
EndSLC = \r | \n | \r\n

StartMLC = "/*"
EndMLC = "*/"

StartString = \"
EndString = \"

WhiteSpace = [ \n\r\t\f]

%xstate SINGLE_LINE_COMMENT
%xstate MULTI_LINE_COMMENT
%xstate STRING

%%

{StartSLC} { yybegin(SINGLE_LINE_COMMENT); buf.append(yytext()); }

//NB: don't check for return stmts in comments
<SINGLE_LINE_COMMENT> {
    {EndSLC} { yybegin(YYINITIAL); buf.append(yytext()); }
    {Any} { buf.append(yytext()); }
    <<EOF>> { return buf.toString(); }
}

{StartMLC} { yybegin(MULTI_LINE_COMMENT); depth++; buf.append(yytext()); }

//NB: don't check for return stmts in comments
<MULTI_LINE_COMMENT> {
    {StartMLC} { depth++; buf.append(yytext()); }
    {EndMLC} { depth--; if(depth == 0) { yybegin(YYINITIAL); } buf.append(yytext()); }
    {Any} { buf.append(yytext()); }
    <<EOF>> { return buf.toString(); }
}

{StartString} { yybegin(STRING); buf.append(yytext()); }

//NB: don't check for return stmts in strings
<STRING> {
    \\\" { buf.append(yytext()); }
    {EndString} { yybegin(YYINITIAL); buf.append(yytext()); }
    {Any} { buf.append(yytext()); }
    <<EOF>> { return buf.toString(); }
}

"return;" { buf.append(yytext()); } //TODO-AC: error in this case?

"return" {WhiteSpace} {
    buf.append(yytext());
    buf.append("Maybe.Just(");
    lookingForSemi = true;
}

"return" / ({StartSLC} | {StartMLC}) {
    buf.append(yytext());
    buf.append(" ");
    buf.append("Maybe.Just(");
    lookingForSemi = true;
}

";" {
    if(lookingForSemi) {
        lookingForSemi = false;
        buf.append(")");
    }
    buf.append(yytext());
}

{Any} { buf.append(yytext()); }

<<EOF>> { 
    if(lookingForSemi) {
        lookingForSemi = false;
        buf.append(")");
        //TODO-AC: error?  demonstrably malformed
    }
    return buf.toString();
}