package metalexer.metalexer;

public class EscapeHelper {
    private EscapeHelper() {}
    
    //escape %} as %%}
    public static String escapeDeclRegion(String original) {
        return "%{" + original.replaceAll("%}", "%%}") + "%}";
    }
    
    //escape %init} as %%init}
    public static String escapeInitRegion(String original) {
        return "%init{" + original.replaceAll("%init}", "%%init}") + "%init}";
    }
    
    //escape %append} as %%append}
    public static String escapeAppendRegion(String original) {
        return "%append{" + original.replaceAll("%append}", "%%append}") + "%append}";
    }
    
    //escape %appendWithStartDelim} as %%appendWithStartDelim}
    public static String escapeAppendWithStartDelimRegion(String original) {
        return "%appendWithStartDelim{" + original.replaceAll("%appendWithStartDelim}", "%%appendWithStartDelim}") + "%appendWithStartDelim}";
    }
    
    //escape :} as %:}
    public static String escapeAction(String original) {
        return "{:" + original.replaceAll(":}", "%:}") + ":}";
    }
    
    //escape LF as \n, CR as \r
    public static String escapeString(String original) {
        return "\"" + original.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r") + "\"";
    }
}
