/*
 * Decompiled with CFR 0.152.
 */
package beaver.spec.ast;

import beaver.Symbol;
import beaver.spec.ast.Node;
import beaver.spec.ast.TreeWalker;

public class Rule
extends Node {
    public final Symbol lhs_sym;
    public final Definition[] defs;

    public Rule(Symbol symbol, Definition[] definitionArray) {
        this.lhs_sym = symbol;
        this.defs = definitionArray;
    }

    public String getLHSSymbolName() {
        return (String)this.lhs_sym.value;
    }

    public void accept(TreeWalker treeWalker) {
        treeWalker.visit(this);
    }

    public static class Definition
    extends Node {
        public final Element[] elements;
        public final Symbol prec_sym_name;
        public final Symbol code;

        public Definition(Element[] elementArray, Symbol symbol, Symbol symbol2) {
            this.elements = elementArray;
            this.prec_sym_name = symbol;
            this.code = symbol2;
        }

        public Definition(Element[] elementArray) {
            this.elements = elementArray;
            this.prec_sym_name = null;
            this.code = null;
        }

        public void accept(TreeWalker treeWalker) {
            treeWalker.visit(this);
        }

        public String getPrecedenceSymbolName() {
            return (String)this.prec_sym_name.value;
        }

        public String getReduceActionCode() {
            return (String)this.code.value;
        }

        public static class Element
        extends Node {
            public final Symbol sym_name;
            public final Symbol alias;
            public final Symbol ebnf_sym;

            public Element(Symbol symbol, Symbol symbol2, Symbol symbol3) {
                this.sym_name = symbol;
                this.alias = symbol2;
                this.ebnf_sym = symbol3;
            }

            public void accept(TreeWalker treeWalker) {
                treeWalker.visit(this);
            }

            public String getName() {
                return (String)this.sym_name.value;
            }

            public String getAlias() {
                return (String)this.alias.value;
            }

            public char getExtUseMark() {
                return this.ebnf_sym.value == null ? (char)' ' : ((String)this.ebnf_sym.value).charAt(0);
            }
        }
    }
}

