/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationProblem;
import metalexer.FileLoaderHelper;
import metalexer.ast.Component;
import metalexer.ast.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLoader {
    private final List<FileLoaderHelper> helpers;
    private final Map<String, Component> components;
    private final Map<String, Layout> layouts;

    public FileLoader(String string) {
        this(Collections.singletonList(string));
    }

    public FileLoader(List<String> list) {
        this.helpers = new ArrayList<FileLoaderHelper>(list.size());
        for (String string : list) {
            this.helpers.add(new FileLoaderHelper(string));
        }
        this.components = new HashMap<String, Component>();
        this.layouts = new HashMap<String, Layout>();
    }

    public Component loadComponent(String string, SortedSet<CompilationProblem> sortedSet) throws IOException {
        if (this.components.containsKey(string)) {
            return this.components.get(string);
        }
        for (FileLoaderHelper fileLoaderHelper : this.helpers) {
            try {
                TreeSet treeSet = new TreeSet();
                Component component = fileLoaderHelper.loadComponent(string, sortedSet);
                if (component == null) continue;
                sortedSet.addAll(treeSet);
                this.components.put(string, component);
                return component;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        this.components.put(string, null);
        return null;
    }

    public Layout loadLayout(String string, SortedSet<CompilationProblem> sortedSet) throws IOException {
        if (this.layouts.containsKey(string)) {
            return this.layouts.get(string);
        }
        for (FileLoaderHelper fileLoaderHelper : this.helpers) {
            try {
                TreeSet treeSet = new TreeSet();
                Layout layout = fileLoaderHelper.loadLayout(string, sortedSet);
                if (layout == null) continue;
                sortedSet.addAll(treeSet);
                this.layouts.put(string, layout);
                return layout;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        this.layouts.put(string, null);
        return null;
    }
}

