#!/usr/bin/env ruby

require "cgi"

metalexer_dir = "../metalexer/"
translator_dir = "../translator/"

cgi = CGI.new("html3")
cgi.out() do
    cgi.html() do
        cgi.head{ cgi.title{"MetaLexer"} } +
        cgi.body() do
            
            dev_manual = []
            user_manual = []
            m2m = []
            m2j = []
            src = []
            
            cgi_files = []
            Dir.open(metalexer_dir) do |dir|
                dir.entries.each do |file|
                    case file
                    when /^Dev Manual/
                        dev_manual << file;
                    when /^User Manual/
                        user_manual << file;
                    when /^metalexer\-metalexer/
                        m2m << file;
                    when /^metalexer\-jflex/
                        m2j << file;
                    when /^metalexer\-src/
                        src << file;
                    end
                end
            end
            
            dev_manual.sort!.reverse!
            user_manual.sort!.reverse!
            m2m.sort!.reverse!
            m2j.sort!.reverse!
            src.sort!.reverse!
            
            cgi.h1{"MetaLexer"} +
            cgi.p{"Compiler toolkits make it possible to rapidly develop compilers and translators for new programming languages.  Recently, toolkit writers have focused on supporting extensible languages and systems that mix the syntaxes of multiple programming languages.  However, this work has not been extended down to the lexical analysis level.  As a result, users of these toolkits have to rely on ad-hoc solutions when they extend or mix syntaxes.  This thesis presents MetaLexer, a new lexical specification language that remedies this deficiency."} +
            cgi.p{"MetaLexer has three key features: it abstracts lexical state transitions out of semantic actions, makes modules extensible by introducing multiple inheritance, and provides cross-platform support for a variety of programming languages and compiler front-end toolchains."} +
            cgi.p{"In addition to designing this new language, we have constructed a number of practical tools.  The most important are a pair of translators that map MetaLexer to the popular JFlex lexical specification language and vice versa."} +
            cgi.p{"We have exercised MetaLexer by using it to create lexers for three real programming languages: AspectJ (and two extensions), a large subset of Matlab, and MetaLexer itself.  The new specifications are easier to read and require much less action code than the originals."} +
            
            cgi.h2{"License"} +
            "MetaLexer is covered by a (modified) BSD " + cgi.a(metalexer_dir + "LICENSE") {"license"} + "." + cgi.br +
            
            cgi.h2{"Current Files"} +
            "My " + cgi.a(metalexer_dir + "thesis.pdf") {"thesis"} + " serves as the de-facto manual for MetaLexer." + cgi.br +
            cgi.br +
            
            "Developers can download the " + cgi.a(metalexer_dir + src.shift){"source"} + " for MetaLexer." + cgi.br +
            "Others will probably prefer a binary distribution:" + cgi.br +
            cgi.ul do
                cgi.li { cgi.a(metalexer_dir + m2m.shift){"MetaLexer-to-MetaLexer"} } +
                cgi.li { cgi.a(metalexer_dir + m2j.shift){"MetaLexer-to-JFlex"} }
            end +
            
            cgi.h2{"JFlex"} +
            "For full functionality, you should download " + cgi.a("http://jflex.de/") {"JFlex"} + "." + cgi.br +
            
            cgi.h2{"JFlex-to-MetaLexer translator"} +
            "The JFlex-to-MetaLexer translator is available separately " + cgi.a(translator_dir) {"here"} + "." + cgi.br +
            
            cgi.h2{"Benchmarks"} +
            "The benchmark suite used for my thesis will be available shortly." + cgi.br +
            
            cgi.h2{"Old Files"} +
            cgi.h3{"Developer Manual (Deprecated)"} +
            cgi.ul do
                dev_manual.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"User Manual (Deprecated)"} +
            cgi.ul do
                user_manual.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"MetaLexer-to-MetaLexer"} +
            cgi.ul do
                m2m.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"MetaLexer-to-JFlex"} +
            cgi.ul do
                m2j.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"Source"} +
            cgi.ul do
                src.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            
            cgi.h2{"Feedback"} +
            "Direct your questions or comments to " + cgi.img("email.gif") + "." + cgi.br
        end
    end
end

