package test.jflex.natlab;

public class NatlabParser {
    static public class Terminals {
        static public final short EOF = 0;
        static public final short COMMA = 1;
        static public final short LINE_TERMINATOR = 2;
        static public final short PLUS = 3;
        static public final short MINUS = 4;
        static public final short SEMICOLON = 5;
        static public final short SEMICOLON_LINE_TERMINATOR = 6;
        static public final short COMMA_LINE_TERMINATOR = 7;
        static public final short IDENTIFIER = 8;
        static public final short END = 9;
        static public final short LSQUARE = 10;
        static public final short LPAREN = 11;
        static public final short LCURLY = 12;
        static public final short NOT = 13;
        static public final short AT = 14;
        static public final short INT_NUMBER = 15;
        static public final short IM_INT_NUMBER = 16;
        static public final short FP_NUMBER = 17;
        static public final short IM_FP_NUMBER = 18;
        static public final short STRING = 19;
        static public final short RCURLY = 20;
        static public final short RPAREN = 21;
        static public final short AND = 22;
        static public final short LT = 23;
        static public final short GT = 24;
        static public final short LE = 25;
        static public final short GE = 26;
        static public final short EQ = 27;
        static public final short NE = 28;
        static public final short OR = 29;
        static public final short SHORTAND = 30;
        static public final short SHORTOR = 31;
        static public final short COLON = 32;
        static public final short RSQUARE = 33;
        static public final short MTIMES = 34;
        static public final short ETIMES = 35;
        static public final short MDIV = 36;
        static public final short EDIV = 37;
        static public final short MLDIV = 38;
        static public final short ELDIV = 39;
        static public final short ASSIGN = 40;
        static public final short FUNCTION = 41;
        static public final short MPOW = 42;
        static public final short EPOW = 43;
        static public final short TRY = 44;
        static public final short WHILE = 45;
        static public final short FOR = 46;
        static public final short SWITCH = 47;
        static public final short IF = 48;
        static public final short GLOBAL = 49;
        static public final short PERSISTENT = 50;
        static public final short SHELL_COMMAND = 51;
        static public final short BREAK = 52;
        static public final short CONTINUE = 53;
        static public final short RETURN = 54;
        static public final short ANNOTATION = 55;
        static public final short ARRAYTRANSPOSE = 56;
        static public final short MTRANSPOSE = 57;
        static public final short PROPERTIES = 58;
        static public final short METHODS = 59;
        static public final short EVENTS = 60;
        static public final short HELP_COMMENT = 61;
        static public final short BRACKET_HELP_COMMENT = 62;
        static public final short ELSEIF = 63;
        static public final short ELSE = 64;
        static public final short CASE = 65;
        static public final short OTHERWISE = 66;
        static public final short DOT = 67;
        static public final short CATCH = 68;
        static public final short CLASSDEF = 69;
        static public final short PARFOR = 70;
        static public final short COMMENT = 71;
        static public final short ELLIPSIS_COMMENT = 72;
        static public final short BRACKET_COMMENT = 73;
        
        static public final String[] NAMES = {
            "EOF",
            "COMMA",
            "LINE_TERMINATOR",
            "PLUS",
            "MINUS",
            "SEMICOLON",
            "SEMICOLON_LINE_TERMINATOR",
            "COMMA_LINE_TERMINATOR",
            "IDENTIFIER",
            "END",
            "LSQUARE",
            "LPAREN",
            "LCURLY",
            "NOT",
            "AT",
            "INT_NUMBER",
            "IM_INT_NUMBER",
            "FP_NUMBER",
            "IM_FP_NUMBER",
            "STRING",
            "RCURLY",
            "RPAREN",
            "AND",
            "LT",
            "GT",
            "LE",
            "GE",
            "EQ",
            "NE",
            "OR",
            "SHORTAND",
            "SHORTOR",
            "COLON",
            "RSQUARE",
            "MTIMES",
            "ETIMES",
            "MDIV",
            "EDIV",
            "MLDIV",
            "ELDIV",
            "ASSIGN",
            "FUNCTION",
            "MPOW",
            "EPOW",
            "TRY",
            "WHILE",
            "FOR",
            "SWITCH",
            "IF",
            "GLOBAL",
            "PERSISTENT",
            "SHELL_COMMAND",
            "BREAK",
            "CONTINUE",
            "RETURN",
            "ANNOTATION",
            "ARRAYTRANSPOSE",
            "MTRANSPOSE",
            "PROPERTIES",
            "METHODS",
            "EVENTS",
            "HELP_COMMENT",
            "BRACKET_HELP_COMMENT",
            "ELSEIF",
            "ELSE",
            "CASE",
            "OTHERWISE",
            "DOT",
            "CATCH",
            "CLASSDEF",
            "PARFOR",
            "COMMENT",
            "ELLIPSIS_COMMENT",
            "BRACKET_COMMENT"
        };
    }
}