package metalexer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.SortedSet;
import java.util.TreeSet;

import metalexer.ast.Layout;

/**
 * A utility for producing the output file corresponding to a given input file.
 * Note that the output should be checked manually before using it as a test.
 */
public class LayoutErrorTestTool {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.LayoutErrorTestTool {basename}");
            System.exit(1);
        }
        String basename = args[0];
        try {
            FileLoader loader = new FileLoader("test/frontend");
            SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();
            Layout actual = loader.loadLayout(basename, problems);
            assert(actual.subtreeNodesHaveCorrectParents());
            actual = actual.processInheritance(loader, problems);
            assert(actual.subtreeNodesHaveCorrectParents());

            PrintWriter out = new PrintWriter(new FileWriter("test/frontend/" + basename + ".out"));
            for(CompilationError error : ProblemUtil.extractErrors(problems)) {
                out.println(ScannerUtil.stringifyValue(error));
            }
            out.close();

            System.exit(0);
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}
