package properties;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class PropertiesLexerTest {
    public static void main(String[] args) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader("scratch/properties/test.properties"));
            PropertiesLexer lexer = new PropertiesLexer(in);
            while(true) {
                Token tok = lexer.getNext();
                if(tok.isEOF) {
                    break;
                }
            }
        } catch(LexerException e) {
            System.err.println(e.getMessage());
        } finally {
            if(in != null) {
                in.close();
            }
        }
    }
}
