package metalexer;

import java.io.PrintWriter;

import beaver.Symbol;

public class ScannerUtil {
    private ScannerUtil() {}

    public static void printSymbol(PrintWriter out, Symbol symbol, String[] names) {
        out.print(names[symbol.getId()]);
        out.print(' ');
        int start = symbol.getStart();
        int startLine = Symbol.getLine(start);
        int startCol = Symbol.getColumn(start);
        int end = symbol.getEnd();
        int endLine = Symbol.getLine(end);
        int endCol = Symbol.getColumn(end);
        if(startLine == endLine) {
            out.print(startLine);
            out.print(' ');
            out.print(startCol);
            out.print(' ');
            out.print(endCol - startCol + 1);
        } else {
            out.print(startLine);
            out.print(' ');
            out.print(startCol);
            out.print(' ');
            out.print(endLine);
            out.print(' ');
            out.print(endCol);
        }
        if(symbol.value != null) {
            out.print(' ');
            out.print('=');
            out.print(stringifyValue(symbol.value));
        }
        out.println();
    }

    public static String stringifyValue(Object value) {
        if(value == null) {
            return null;
        }
        return value.toString().replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
    }
}