
/* bintree.h - Binary tree structure */

#ifndef _BINTREE_H
#define _BINTREE_H

#define const 

typedef int (*comparison_function_t) (void *, void *);
/* pointer to a function which takes two void pointers,
   compares the data pointed to by the two pointers, and returns
   -1 if the first piece of data "comes before" the second one,
   -1 if the first piece of data "comes after" the second one,
   and 0 if the two pieces of data are equal.
*/

struct BinaryTreeCell;

typedef struct BinaryTree {
    int nbelem;  /* number of elements in the tree */
    comparison_function_t cmpfct;  /* function to compare elements */
    struct BinaryTreeCell *root;  /* root cell */
} BinaryTree;


void BinaryTree_initialize (BinaryTree *tree, comparison_function_t f);
/* Initializes the 'tree' structure with the comparison function 'f'. */

void BinaryTree_empty (BinaryTree *tree);
/* Deletes all cells of the tree and their contents. */
/* free() is called on the contents of the cells. */

int BinaryTree_insert (BinaryTree *tree, void *elem);
/* Inserts the element pointed to by 'elem' in the designated tree. */
/* If the element isn't already in the tree, it is inserted and the
   function returns 1. If the element is already in the tree, the
   tree is not changed and the function returns 0.
   'elem' should point to a dynamically allocated region.
*/

int BinaryTree_cardinal (BinaryTree *tree);
/* Returns the number of elements in the designated tree. */

void BinaryTree_iterate (BinaryTree *tree, void (*f) (void *));
/* Calls function 'f' for all elements of the tree, in order */
/* A pointer to an element is passed to function 'f'. */


#endif  /* _BINTREE_H */

