/* bt1.c - Binary Tree Benchmark */
/* By Pierre Sarrazin <sarrazip@cs.mcgill.ca> */
/* September 1994 */

/* This program assumes that sizeof(unsigned long) == 4. */
/* This source requires an ANSI C compiler. */

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include "bintree.h"


unsigned long seed;
unsigned long hash_value = 0;

extern struct BinaryTreeCell *new_BTC ();

static unsigned long random (void)
{
    seed = seed * 1103515245 + 12345;
    return seed;
}


static int getline (char *dest, size_t max)
{
    int i, lg;

    lg = random() % 79 + 1;
    if (lg > max - 1)
	lg = max - 1;
    for (i = 0; i < lg; i++)
	dest[i] = random() % ('~' - '!' + 1) + '!';  /* any printable char */
    dest[lg] = '\0';
    return lg;
}


static int funny_strcmp (void *v1, void *v2)
/* Compares the strings pointed to by 'v1' and 'v2' starting at the end. */
/* (i.e. if 'r1' and 'r2' are reversed versions of 'v1' and 'v2', then
   this function is equivalent to strcmp(r1, r2). */
{
    const unsigned char *s1 = (const unsigned char *) v1;
    int lg1 = strlen(s1);
    const unsigned char *s2 = (const unsigned char *) v2;
    int lg2 = strlen(s2);
    int i1, i2;

    for (i1 = lg1, i2 = lg2; i1 >= 0 && i2 >= 0; i1--, i2--)
	if (s1[i1] != s2[i2])
	    return (s1[i1] > s2[i2] ? +1 : -1);
    if (i1 < 0)
	if (i2 < 0)
	    return 0;  /* s1 and s2 are equal */
	else
	    return -1;  /* s1 is a suffix of s2 */
    else
	return +1;  /* s2 is a suffix of s1 */
}


static void eat_line (void *info)
{
    const unsigned char *s = (const unsigned char *) info;

    for ( ; *s; s++) {
	hash_value ^= *s;
	hash_value = (hash_value << 1) | (hash_value >> 31);
    }
}


int main ()
{
    char line[512];
    BinaryTree *bintree;
    int lg;
    char *vec;
    unsigned long ctr, nbiter;

    bintree = (BinaryTree *) new_BTC(NULL, NULL, NULL);

    if (scanf("%lu%lu", &nbiter, &seed) != 2) {
	fprintf (stderr, "Usage: btbm <number of iterations> <seed>\n");
	exit (1);
    }
    BinaryTree_initialize (bintree, funny_strcmp);

    for (ctr = nbiter; ctr; ctr--) {
        lg = getline(line, sizeof(line));
	vec = (char *) malloc(lg + 1);
	assert (vec);
	strcpy (vec, line);
	BinaryTree_insert (bintree, vec);
    }

    BinaryTree_iterate (bintree, eat_line);

    BinaryTree_empty (bintree);
    assert (BinaryTree_cardinal(bintree) == 0);

    printf ("%lu\n", hash_value);
    exit (0);
}

