/* main.h */

#ifndef MAIN_H
#define MAIN_H

/* 
 * Defines for controlling compilation...
 */

#define UNIX 

#define ScaleMatrix /* scale before factor */
#define SolveMatrix /* solve and output results after the factor */
#define OutputSolution  /* output answers after the solve... */
#ifdef NEVER

/* stuff for the Sequent */
#define SEQUENT
#define OLDC  
#define THINKC               /* when on the mac */
#define DEBUG
#define VERBOSE              /* more debugging output */
#define TRUE_RANDOM          /* random runs each time */
#define RescaleDuringFactor  /* rescale matrix periodically during factor? */

#endif

#ifndef DEBUG
#define NDEBUG       /* turn off asserts */
#endif

#define NumElements 9000 /* this # of elements in matrix */
 
#define MaxRow 500        /* number of rows, columns in matrix */
#define MaxCol MaxRow     /* must be a square matrix...        */ 
#define MaxVal 1000       /* range of values will be -maxval .. maxval */

#define MaxRand 2147483647  /* 2^31 - 1 */
#define MaxLong MaxRand


/* 
 * Typedefs...
 */

typedef char boolean;

#define True  1
#define False 0
#define And   &&
#define Or    ||
#define Not   !

#define Nop   /* nothing */


/* 
 * Prototypes...
 */

#ifdef OLDC

double *init();
long    getRandomIntInRange();
double  getRandomFloatInRange();
double  cputime();

#else

double *init(int argc, char **argv);
void    test1(void);
void    test2(void);
long    getRandomIntInRange(long upper);
double  getRandomFloatInRange(long lower, long upper);
double  cputime(void);
void    error(char *msg);

#endif

#endif

