#include "em3d.h"
#include "make_graph.h"
#define chatting printf

void print_graph(graph_t graph) 
{
  node_t *cur_node;

  for(cur_node=graph.e_nodes; cur_node; cur_node=cur_node->next)
    {
      chatting("E: value %f, from_count %d\n",cur_node->value,
	       cur_node->from_count);
    }
  for(cur_node=graph.h_nodes; cur_node; cur_node=cur_node->next)
    {
      chatting("H: value %f, from_count %d\n",cur_node->value,
	       cur_node->from_count);
    }
}


int main(int argc, char *argv[])
{
  graph_t graph;

  dealwithargs(argc,argv);
  init_random(2);
  graph=initialize_graph();
#ifndef RUNTIME
  print_graph(graph);
#endif
  compute_nodes(graph.e_nodes);
  compute_nodes(graph.h_nodes);
#ifndef RUNTIME
  chatting("Completed a computation phase\n");
  print_graph(graph);
#endif
  
}
