/* defs.h */

/*
 * Include file of standard definitions needed for hierarchical 
 *   N-body code.
 *
 * NOTE: all .c files (should) include this .h file.
 *
 * Modified By:  Joe Hummel, UC-Irvine, 1992
 *
 * Original Author:
 * Copyright (c) 1991, Joshua E. Barnes, Honolulu, HI.
 * 	    It's free because it's yours.
 */


#ifndef DEFS_H  /* prevent multiple includes */
#define DEFS_H


/*
 * DEFINES FOR COMPILATION
 *
 */

#define NDEBUG                /* controls asserts -- define to turn off    */
/* #define DEBUG  */          /* controls debug output -- define to enable */
/* #define COMPILE_AS_ONE */  /* define to compile everything in main.c    */

#define UNIX                  /* are we running under UNIX, any flavor?    */
/* #define CRAY */
/* #define MAC  */
/* #define PC   */

/* Rakesh #define TIME_ONLY *//* define if only want a timing run -- no output */

/* #define SINGLEPREC */  /* controls size of real numbers         */

#define THREEDIM          /* bodies exist in a 3-dimensional space */
/* #define TWODIM     */  /* MUST define 3 dim or 2 dim!           */


/*
 * other includes we need (these depend on defines above)
 */

#include <assert.h>
#include <stdio.h>
#ifdef MAC
#include <stdlib.h>
#endif
#include <math.h>

#include "stdinc.h"
#include "vectmath.h"


/*
 * BODY and CELL data structures are used to represent the tree:
 *
 *         +-----------------------------------------------+
 * root--> | CELL: mass, pos, quad, /, o, /, /, /, /, o, / |
 *         +---------------------------|--------------|----+
 *                                     |              |
 *    +--------------------------------+              |
 *    |                                               |
 *    |    +--------------------------------+         |
 *    +--> | BODY: mass, pos, vel, acc, phi |         |
 *         +--------------------------------+         |
 *                                                    |
 *    +-----------------------------------------------+
 *    |
 *    |    +-----------------------------------------------+
 *    +--> | CELL: mass, pos, quad, o, /, /, o, /, /, o, / |
 *         +------------------------|--------|--------|----+
 *                                 etc      etc      etc
 */


/*
 * NODE: record that defines leaves (bodies or particles) and
 *   internal nodes (point masses or cells).
 */

#define BODY 01  /* type code for bodies/particles     */
#define CELL 02  /* type code for cells/internal nodes */

#define NSUB (1 << NDIM)  /* subcells per cell */

typedef struct Node {
    short   type;        /* code for node type     */
    real    mass;        /* mass of body           */
    vector  pos;         /* position of body       */
    struct  Node *next;  /* next particle in leaves list */
      /* (also used to keep cells on a free list)        */
    
    struct/*union Rakesh*/ {
      struct {         /* BODIES (leaves)        */
        vector  vel;   /* velocity of body       */
        vector  acc;   /* acceleration of body   */
        real    phi;   /* potential at body      */
      } body;
      struct {         /* CELLS (internal nodes) */
        struct  Node *subp[NSUB]; /* descendents */
      } cell;
    } un;
} Node_t, *NodePtr_t;
  

/*
 * Macros for accessing fields of above Node definition...
 */
 
#define Type(p) ((p)->type)                 /* access common portion */
#define Mass(p) ((p)->mass)
#define Pos(p)  ((p)->pos)
#define Next(p) ((p)->next)

#define Vel(p)  ((p)->un.body.vel)          /* access body data */
#define Acc(p)  ((p)->un.body.acc)
#define Phi(p)  ((p)->un.body.phi)

#define Subp(p,i) ((p)->un.cell.subp[(i)])  /* access cell data */

#endif
