/* globals.c */

/*
 * Global variables for hierarchical N-body code.
 *
 * Modified By:  Joe Hummel, UC-Irvine, 1992
 *
 * Original Author:
 * Copyright (c) 1991, Joshua E. Barnes, Honolulu, HI.
 * 	    It's free because it's yours.
 */

#include "globals.h"


/* ######################################################################### */
/*
 * Global default parameters for this simulation run.
 */
 
string g_defv[] = {       /* DEFAULT PARAMETER VALUES */

   	 /* file names for input/output                        */
    "in=",              /* snapshot of initial conditions  */
    "out=",             /* stream of output snapshots      */

    /* params, used if no input specified, to make a Plummer Model */
    "nbody=128",        /* number of particles to generate         */
    "seed=123",         /* random number generator seed            */

    /* params to control N-body integration           */
    "dtime=0.025",      /* integration time-step      */
    "eps=0.05",         /* usual potential softening  */
    "tol=1.0",          /* cell subdivision tolerence */

    "tstop=2.0",        /* time to stop integration   */
    "dtout=0.25",       /* data-output interval       */

    "VERSION=2.0",      /* JEH  11 September 1992     */
    NULL,
};


/* ######################################################################### */
/*
 * Globals for main simulation routines.
 */
 
string    g_headline;  /* message describing calculation      */
string    g_infile;    /* file name for snapshot input        */
string    g_outfile;   /* file name for snapshot output       */
real      g_dtime;     /* timestep for leapfrog integrator    */
real      g_dtout;     /* time between data outputs           */
real      g_tstop;     /* time to stop calculation            */
int32     g_nbody;     /* number of bodies in system          */
NodePtr_t g_particles; /* points to allocated nodes of bodies */
real      g_tnow;      /* current value of simulation time    */
real      g_tout;      /* time next output is due             */
int32     g_nstep;     /* number of integration steps so far  */
int32     g_n2bcalc;   /* total body-body force calculations  */
int32     g_nbccalc;   /* total body-cell force calculations  */
int32     g_selfint;   /* count erroneous self-interactions   */


/* ######################################################################### */
/*
 * Globals for working with octree.
 */
 
NodePtr_t  g_root;  /* root node of Octree...                */

/* Integerized coordinates: used to mantain octree:          */
vector     g_rmin;  /* lower-left corner of coordinate box   */
real       g_rsize; /* side-length of integer coordinate box */


/* ######################################################################### */
/*
 * Parameters and results for gravitational calculation.
 */

real    g_tol;        /* accuracy parameter: 0.0 => exact     */
real    g_eps;        /* potential softening parameter        */
int32   g_n2bterm;    /* count body-body terms evaluated      */
int32   g_nbcterm;    /* count body-cell terms evaluated      */
bool    g_skipself;   /* true if self-interaction skipped OK  */

