/* globals.h */

/*
 * Include file for accesing global variables of hierarchical 
 *   N-body code.
 *
 * Modified By:  Joe Hummel, UC-Irvine, 1992
 *
 * Original Author:
 * Copyright (c) 1991, Joshua E. Barnes, Honolulu, HI.
 * 	    It's free because it's yours.
 */


#ifndef GLOBALS_H  /* prevent multiple includes */
#define GLOBALS_H

#include "defs.h"


/* ######################################################################### */
/*
 * Global default parameters for this simulation run.
 */
 
extern string g_defv[];


/* ######################################################################### */
/*
 * Globals for main simulation routines.
 */
 
extern string  g_headline; /* message describing calculation      */
extern string    g_infile;    /* file name for snapshot input        */
extern string    g_outfile;   /* file name for snapshot output       */
extern real      g_dtime;     /* timestep for leapfrog integrator    */
extern real      g_dtout;     /* time between data outputs           */
extern real      g_tstop;     /* time to stop calculation            */
extern int32     g_nbody;     /* number of bodies in system          */
extern NodePtr_t g_particles; /* points to allocated nodes of bodies */
extern real      g_tnow;      /* current value of simulation time    */
extern real      g_tout;      /* time next output is due             */
extern int32     g_nstep;     /* number of integration steps so far  */
extern int32     g_n2bcalc;   /* total body-body force calculations  */
extern int32     g_nbccalc;   /* total body-cell force calculations  */
extern int32     g_selfint;   /* count erroneous self-interactions   */


/* ######################################################################### */
/*
 * Globals for working with octree.
 */
 
extern NodePtr_t  g_root;  /* root node of Octree...                */

/* Integerized coordinates: used to mantain octree:                 */
extern vector     g_rmin;  /* lower-left corner of coordinate box   */
extern real       g_rsize; /* side-length of integer coordinate box */


/* ######################################################################### */
/*
 * Parameters and results for gravitational calculation.
 */

extern real    g_fcells;    /* ratio of cells/bodies allocated      */
extern real    g_tol;       /* accuracy parameter: 0.0 => exact     */
extern real    g_eps;       /* potential softening parameter        */
extern int32   g_n2bterm;   /* count body-body terms evaluated      */
extern int32   g_nbcterm;   /* count body-cell terms evaluated      */
extern bool    g_skipself;  /* true if self-interaction skipped OK  */
extern bool    g_debug;     /* control debugging messages           */

#endif

