/* io.h */

/*
 * Include file for I/O module of hierarchical N-body code.  Defines 
 *   its prototypes.
 *
 * Modified By:  Joe Hummel, UC-Irvine, 1992
 *
 * Original Author:
 * Copyright (c) 1991, Joshua E. Barnes, Honolulu, HI.
 * 	    It's free because it's yours.
 */


#ifndef IO_H  /* prevent multiple includes */
#define IO_H

/*
 * Prototypes
 */

void inputdata(void);
void initoutput(void);
void stopoutput(void);
void output(void);

/*
 * Local prototypes...
 */

local void printvec(string name, vector vec);
local void diagnostics(real etot[3], vector cmphase[2], vector amvec);
local void in_int(stream str, int32 *iptr);
local void in_real(stream str, real *rptr);
local void in_vector(stream str, vector vec);
local void out_int(stream str, int32 ival);
local void out_real(stream str, real rval);
local void out_vector(stream str, vector vec);

#endif
