/* load.h */

/*
 * Include file for load module of hierarchical N-body code.  Defines 
 *   its prototypes.
 *
 * Modified By:  Joe Hummel, UC-Irvine, 1992
 *
 * Original Author:
 * Copyright (c) 1991, Joshua E. Barnes, Honolulu, HI.
 * 	    It's free because it's yours.
 */


#ifndef LOAD_H  /* prevent multiple includes */
#define LOAD_H

/*
 * Prototypes
 */
 
void maketree(NodePtr_t btab, int32 nbody);

/*
 * Local prototypes...
 */

local void       expandbox(NodePtr_t p);
local void       loadtree(NodePtr_t p);
local bool       intcoord(int32 xp[NDIM], vector rp);
local int        subindex(int32 x[NDIM], int32 l);
local void       hackcofm(NodePtr_t q);
local NodePtr_t  makecell(void);

#endif
