/* stdinc.h */

/*
 * Include file of universal C definitions.
 *
 * Modified By:  Joe Hummel, UC-Irvine, 1992
 *
 * Original Author:
 * Copyright (c) 1991, Joshua E. Barnes, Honolulu, HI.
 * 	    It's free because it's yours.
 */

#ifndef STDINC_H  /* prevent multiple includes */
#define STDINC_H


/*
 * INT32: let's make sure we all use 32-bit ints.
 */
 
typedef long int32;  /* if this changes, update macros below!! */

#define IN_INT32(stream,iptr) \
  fscanf(stream, "%ld", iptr)
#define OUT_INT32(stream,i,fieldSizeStr) \
  fprintf(stream,"%" fieldSizeStr "ld",i)

#ifdef CRAY
#  define IMAX  (1 << 22)          /* Cray uses 24-bit ints      */
#else
#  define IMAX  ((int32) 1 << 30)  /* highest bit of int32 coord */
#endif

#ifdef CRAY       /* see util.c -- use 32767 on CRAY, MAC, PC/AT */
#define XRAND_DIVISOR 32767.0
#else
#ifdef MAC
#define XRAND_DIVISOR 32767.0
#else
#ifdef PC
#define XRAND_DIVISOR 32767.0
#else
#define XRAND_DIVISOR 2147483647.0
#endif
#endif
#endif


/*
 * STREAM: a replacement for FILE *.
 */

typedef FILE *stream;


/*
 * BOOL, TRUE and FALSE: standard names for logical values.
 */

typedef short int bool;

#define FALSE 0
#define TRUE  1
#define And   &&
#define Or    ||
#define Not   !


/*
 * BYTE: a short name for a handy chunk of bits.
 */

typedef unsigned char byte;


/*
 * STRING: for null-terminated strings which are not taken apart.
 */

typedef char *string;

#define EOS  '\0'  /* end of string terminator */


/*
 * REAL: default type is double; if single precision calculation is
 * supported and desired, compile with -DSINGLEPREC.
 */

#ifndef  SINGLEPREC
  typedef  double  real, *realptr;
#else
  typedef  float   real, *realptr;
#endif


/*
 * PROC, IPROC, RPROC: pointers to procedures, integer functions, and
 * real-valued functions, respectively.
 */

typedef void  (*proc)();
typedef int32 (*i32proc)();
typedef real  (*rproc)();


/*
 * LOCAL: declare something to be local to a file.
 * PERMANENT: declare something to be permanent data within a function.
 */

#define local static
#define permanent static


/*
 * STREQ: handy string-equality macro.
 */

#define streq(x,y) (strcmp((x),(y)) == 0)


/*
 *  PI, etc. -- mathematical constants
 */

#define   PI         3.14159265358979323846
#define   TWO_PI     6.28318530717958647693
#define   FOUR_PI   12.56637061435917295385
#define   HALF_PI    1.57079632679489661923
#define   FRTHRD_PI  4.18879020478639098462


/*
 *  ABS: returns the absolute value of its argument
 *  MAX: returns the argument with the highest value
 *  MIN: returns the argument with the lowest value
 */

#define   ABS(x)    (((x) < 0) ? -(x) : (x))
#define   MAX(x,y)  (((x) > (y)) ? (x) : (y))
#define   MIN(x,y)  (((x) < (y)) ? (x) : (y))

#endif

