/* util.c */

/*
 * Utility module for hierarchical N-body code.
 *
 * Public routines:  xrand()
 *                   error()
 *                   cputime()
 *
 * Modified By:  Joe Hummel, UC-Irvine, 1992
 *
 * Original Author:
 * Copyright (c) 1991, Joshua E. Barnes, Honolulu, HI.
 * 	    It's free because it's yours.
 */

#include <errno.h>
#include <stdlib.h>
#include <varargs.h> 

#include "defs.h"

#include "util.h"


/* ######################################################################### */
/*
 * XRAND: generate floating-point random number.
 */

double xrand(double xl, double xh)  /* lower, upper bounds on number */
{
    return (xl + (xh - xl) * ((double) rand()) / XRAND_DIVISOR);
}


/* ######################################################################### */
/*
 * ERROR: scream and die quickly.  Must pass 2 additional string args, 
 *   which are printed if the formatting controls in "msg" parameter 
 *   specify %s. 
 */

void error(string msg, ...)
{
    va_list  args;
#ifdef Rakesh
    va_start(args, msg);
    vfprintf(stderr, msg, args);  /* print error message      */ 
    if (errno != 0)               /* system error msg as well */
      perror("Error");
    va_end(args);
#endif
    exit(0);  /* die, but return with success to prevent core dump */
}


/* ######################################################################### */
/*
 * CPUTIME: compute CPU time in seconds.
 */

#ifdef UNIX 

#include <sys/time.h>
/* #include <sys/times.h> */
#include <sys/resource.h>

double cputime()
{
    struct rusage  usage;
    double         time;
    
    getrusage(RUSAGE_SELF, &usage);

    time = (double) usage.ru_utime.tv_sec
           + (usage.ru_utime.tv_usec / 1000000.0)
           + (double) usage.ru_stime.tv_sec
           + (usage.ru_stime.tv_usec / 1000000.0);
           
    return time;
}

#else

double cputime()
{ 
    return 0.0;  /* otherwise don't know what to do... */
}

#endif


