/* TabulaRasa.h -- Public header file for TabulaRasa */


#ifndef _ORATabulaRasa_h
#define _ORATabulaRasa_h

#include <X11/Core.h>


/* Resources:

   Name                 Class        RepType      DefaultValue
   -------------------- ------------ ------------ -------------
   (from RectObj)
   (from WindowObj)
   (from Core)
   (from TabulaRasa)
   
*/

/* Whenever an expose event or call to redraw occurs, the enscriber is
   called with the following arguments (in order):
      TabulaRasaWidget tw;
      Drawable d;
	  unsigned int dwidth,dheight,x,y,width,height
   The window is cleared within the (x,y)-(width,height) rectangle
   (though the entire thing can be cleared by a call to Clear()) */
	  
typedef void (*Enscriber)();

extern WidgetClass tabulaRasaWidgetClass;

typedef struct _TabulaRasaClassRec *TabulaRasaWidgetClass;
typedef struct _TabulaRasaRec      *TabulaRasaWidget;

#ifndef _TabulaRasa_Proto
extern void TRSetEnscriber( /* TabulaRasaWidget tw; Enscriber e; */ );
extern void TRRedraw( /* TabulaRasaWidget tw; unsigned int x,y,width,height; */ );
extern void TRClear( /* TabulaRasaWidget tw */ );
extern Pixmap TRGetBuff( /* TabulaRasaWidget tw; */ );
extern GC TRGetGC( /* TabulaRasaWidget tw; int which; */ );
extern void TRGetDimensions( /* TabulaRasaWidget tw; int *w; int *h; */ );
#endif

#define XtNpixmapWidth  "pixmapWidth"
#define XtNpixmapHeight "pixmapHeight"

#define XtCPixmapWidth  "PixmapWidth"
#define XtCPixmapHeight "PixmapHeight"

/* Constants to pass to TRGetGC */
#define TR_EraseGC 1
#define TR_DrawGC  0

#endif
