/* PUGBFS.C  Breadth-first search of triangulation */

#include "pug.h"


/* Some local structure definitions to perform bfs */

typedef struct trianglelist_ {
  triangle *t;
  struct trianglelist_ *next;
} trianglelist;

typedef struct bfstrianglelist_ {
  trianglelist *head;
  trianglelist *tail;
} bfstrianglelist;

/* And some operations on BFSs */
#define initbfs(BFS) ((BFS)->head = (BFS)->tail = NULL)
#define enbfs(BFS,Node) {trianglelist *BFSNL; \
                         BFSNL = (trianglelist *)malloc(sizeof(trianglelist)); \
                         if(BFSNL==NULL) { \
                          fprintf(stderr,"Out of memory\n"); \
                          return; } \
                         BFSNL->t = (Node); \
                         BFSNL->next = NULL; \
                         if((BFS)->head==NULL) (BFS)->head = BFSNL; \
                         else (BFS)->tail->next = BFSNL; \
                         (BFS)->tail = BFSNL; }
#define debfs(BFS,NodePtr) {trianglelist *nl; if((BFS)->head!=NULL) { \
                                                *(NodePtr) = (BFS)->head->t; nl = (BFS)->head; \
                                                (BFS)->head = (BFS)->head->next; \
                                                free(nl); \
                                                if((BFS)->head==NULL) (BFS)->tail = NULL;} \
                                              else \
                                                *(NodePtr) = NULL; }

static triangle *incidenttriangle(/* node *n1,*n2; int direction; */);
static int isanedge(/* node *n1,*n2; nodelist *elhead; */);


static int isanedge(n1,n2,elhead)
	 node *n1,*n2;
	 edgelist *elhead; 
{
  edgelist *el;

  el = elhead;
  while(el!=NULL) {
    if((el->n1==n1 && el->n2==n2) || (el->n1==n2 && el->n2==n1))
      return(True);
    el = el->next;
  }

  return(False);
}


/* Given 2 nodes that form an edge, and a direction (either Sarea_Left or
   Sarea_Right), this routine locates the triangle on that side
   of the edge and returns a pointer to it */
static triangle *incidenttriangle(n1,n2,direction)
	 node *n1,*n2;
	 int direction;
{
  int tcorn;
  node *n3;
  triangle *t;

  t=n1->thead;
  while(t!=NULL) {

	tcorn=WhichCorner(t,n1);

   	n3=NULL;
	if((t->c[(tcorn+1)%3]).n==n2) n3=(t->c[(tcorn+2)%3]).n;
	if((t->c[(tcorn+2)%3]).n==n2) n3=(t->c[(tcorn+1)%3]).n;

	if(n3!=NULL && sarea(n1,n2,n3)==direction)
	  return(t);

	t=t->c[tcorn].next;
  }

  return(NULL);
}



/* Delete all triangles external to the domain of interest.
   For each edge of the boundary, perform a BFS on the
   triangulation exterior to the domain, deleting all
   triangles encountered. */
void removeexternaltriangles(th,elhead)
	 triangle **th;
	 edgelist *elhead;
{
  edgelist *el;
  node *n;
  bfstrianglelist bfshead;
  triangle *t,*tt;
  int tcorn1,tcorn2,tcorn3,i;

  i = 0;
  /* First mark boundary */
  el = elhead;
  while(el!=NULL) {
    el->n1->flags |= FLAG_Mark;
	i++;
    el = el->next;
  }

  printf("Boundary has %d edges\n",i);

  initbfs(&bfshead);

  /* Find a triangle to start things off */
  el = elhead;
  while(el!=NULL) {
    t = incidenttriangle(el->n1,el->n2,Sarea_Right);

	while(t!=NULL) {
	  
	  /* Enqueue any neighbours of t that have not already been queued */
	  for(i=0;i<3;i++) {
		tt = incidenttriangle(t->c[i].n,t->c[(i+1)%3].n,Sarea_Left);
		if(tt==t) tt = incidenttriangle(t->c[i].n,t->c[(i+1)%3].n,Sarea_Right);
		if(tt!=NULL && !((tt->flags)&FLAG_Mark)) {
		  
		  if(!((t->c[i].n->flags)&FLAG_Mark) ||
			 !((t->c[(i+1)%3].n->flags)&FLAG_Mark) ||
			 !isanedge(t->c[i].n,t->c[(i+1)%3].n,elhead)) {
			tt->flags |= FLAG_Mark;
			enbfs(&bfshead,tt);
		  }
		}
	  }
	  
	  /* And destroy t itself */
	  unmake_triangle(th,t);
	  
	  debfs(&bfshead,&t);
	}

    el = el->next;
  }
	
  /* Finally, unmark boundary */
  el = elhead;
  while(el!=NULL) {
    el->n1->flags &= ~FLAG_Mark;
    el = el->next;
  }
}

/*void emptyregion(nodelist *nlhead,triangle **thead,node **nhead) {
  triangle *t,*nextt;
  node *n,*nlast,*nnext;

  bfsempty(nlhead);

  t = *thead;
  while(t!=NULL) {
    nextt = t->next;
    if((t->flags)&FLAG_Mark) {

      GrLine((t->c[0].n)->ix,(t->c[0].n)->iy,(t->c[1].n)->ix,(t->c[1].n)->iy,GrWhite());
      GrLine((t->c[1].n)->ix,(t->c[1].n)->iy,(t->c[2].n)->ix,(t->c[2].n)->iy,GrWhite());
      GrLine((t->c[2].n)->ix,(t->c[2].n)->iy,(t->c[0].n)->ix,(t->c[0].n)->iy,GrWhite());

      unmake_triangle(thead,t);
    }
    t = nextt;
  }

  
  n = *nhead; nlast = NULL;
  while(n!=NULL) {
    nnext = n->next;

    if(n->thead==NULL && !((n->flags)&FLAG_RealBoundary)) {
      if(nlast==NULL) *nhead = nnext;
      else nlast->next = nnext;
      free(n);

    } else nlast = n;

    n = nnext;
  }
}*/

