/* PUGCOEFF.C  Coefficient assembly routines */

#include "pug.h"

/* First, a node to hold data needed when working with a single triangle */
typedef struct localnode_type {

  double x,y,                  /* Local x,y coords relative to centroid */
         xm,ym,                /* Coords of mid-point */
         xmul,ymul,
         cc[3];
  node *n;                     /* Actual node this corresponds to */

} localnode;


/* Assemble coefficients for each cv */
void coeff(nh,th,nfs)
	 node *nh;
	 triangle *th;
	 int nfs;
{
  int i,j,k,p;
  double x0,y0,det,fac,volume,asp,asc;
  node *n;
  triangle *t;
  localnode ln[3];

  /* Initialization of all coefficients for diffusion problem */

  t=th;
  while(t!=NULL) {

	for(i=0;i<3;i++) {
	  
	  t->c[i].a[0] = 0.0;
	  t->c[i].a[1] = 0.0;
	}

	t=t->next;
  }

  n=nh;
  while(n!=NULL) {
	
	n->ac   = 0.0;
	n->acon = 0.0;

	n=n->next;
  }


  /* Now assemble coefficients for each triangle */

  /* Assign gamma and source terms */

  gamsor(nh,nfs);

  t = th;
  while(t!=NULL) {

	/* Create local data structures for this triangle */
	
	/* Compute coordinates of origin (centroid of triangle) */
	x0 = ((t->c[0].n)->x + (t->c[1].n)->x + (t->c[2].n)->x) / 3.0;
	y0 = ((t->c[0].n)->y + (t->c[1].n)->y + (t->c[2].n)->y) / 3.0;

	/* Shift x,y coords of triangle to have centroid at origin */
	for(k=0;k<3;k++) {
	  
	  ln[k].x = (t->c[k].n)->x - x0;
	  ln[k].y = (t->c[k].n)->y - y0;
	}

	/* Conduction part of coefficients */
	
	/* Compute determinant and accompanying factor */
	det = ln[0].x * ln[1].y + ln[1].x * ln[2].y + ln[2].x * ln[0].y -
	  ln[0].x * ln[2].y - ln[1].x * ln[0].y - ln[2].x * ln[1].y;

	/* Note that the gamma from node 0 is being used for the entire triangle */
	fac = (-(t->c[0].n)->gamma) / det;

	/* Compute x,y coords for midpoints */
	for(k=0;k<3;k++) {
	  
	  ln[k].xm = (ln[(k+1)%3].x + ln[(k+2)%3].x) / 2.0;
	  ln[k].ym = (ln[(k+1)%3].y + ln[(k+2)%3].y) / 2.0;
	  
	  ln[k].xmul = ln[(k+1)%3].x - ln[(k+2)%3].x;
	  ln[k].ymul = ln[(k+1)%3].y - ln[(k+2)%3].y;
	}

	for(p=0;p<3;p++) {
	  for(k=0;k<3;k++) {
		
		ln[k].cc[p] = fac * (ln[p].ym * ln[k].ymul + 
							 ln[p].xm * ln[k].xmul);
	  }
	}

	/* Compute element volume. Since this is unit depth, volume is the
	   area, which is just the determinant/2. There are 3 equal sections,
	   so each individual volume is determinant/6 */
	volume = fabs(det / 6.0);
		
	asp = volume * (t->c[0].n)->sp;
	asc = volume * (t->c[0].n)->sc;

	/* Start actual coefficient assembly. */

	/* wrt node 0 */
	(t->c[0].n)->ac   += ln[0].cc[1] - ln[0].cc[2] - asp;
	t->c[0].a[0]      += ln[1].cc[2] - ln[1].cc[1];
	t->c[0].a[1]      += ln[2].cc[2] - ln[2].cc[1];
	(t->c[0].n)->acon += asc;

	/* wrt node 1 */
	(t->c[1].n)->ac   += ln[1].cc[2] - ln[1].cc[0] - asp;
	t->c[1].a[0]      += ln[2].cc[0] - ln[2].cc[2];
	t->c[1].a[1]      += ln[0].cc[0] - ln[0].cc[2];
	(t->c[1].n)->acon += asc;
		   
	/* wrt node 2 */
	(t->c[2].n)->ac   += ln[2].cc[0] - ln[2].cc[1] - asp;
	t->c[2].a[0]      += ln[0].cc[1] - ln[0].cc[0];
	t->c[2].a[1]      += ln[1].cc[1] - ln[1].cc[0];
	(t->c[2].n)->acon += asc;

	t=t->next;
  }
}
