/* PUGGRID.C  Grid generation routines */

#include "pug.h"


#define NODEFILE "nodedata"            /* Name of input data file name */

/* Max length of an input line for reading in points */
#define MAXLINEIN 100

/* Number of nodes in a random creation of nodes */
#define NUMNODES 800


/* Procedure create_grid() creates both the linked list of nodes and the
   linked list of triangles representing the volume/area in question */
void create_grid(nh,th)
	 node **nh;
	 triangle **th;
{
  int i,flags;
  char linein[MAXLINEIN+1];
  double x,y;
  FILE *f;
  node *n,*lastn;

  lastn=NULL;

  f=fopen(NODEFILE,"rt");
  if(f==NULL) {

	fprintf(stderr,"Unable to open input file \"%s\"\n",NODEFILE);
	exit(1);

  } 

  i=0; flags=FLAG_RealBoundary;

  while(!feof(f)) {
	
	if(fgets(linein,MAXLINEIN,f)==NULL) break;
	if(!strncasecmp(linein,"internal",8)) {
	  
	  flags=0;
	  continue;
	}
	
	if(sscanf(linein,"%lf%lf",&x,&y)!=2) break;
	
	n=newnode(x,y,flags);
	
	if(lastn==NULL) *nh=n;
	else lastn->next=n;
	
	lastn=n;
	/* printf("%s node: (%g,%g)\n",
		   ((n->flags)&FLAG_RealBoundary) ? "Boundary" : "Internal",
		   n->x,n->y);
	*/
	
	i++;
  }
  
  fclose(f);
  
  if(i==0) {
	fprintf(stderr,"No nodes found in input file \"%s\"\n",NODEFILE);
	exit(1);
  }

  printf("Triangulating...\n");

  /* Triangulate nodes */
  delaunay(*nh,th);

  forceedges(*nh,th);

  printf("Reordering nodes...\n");

  reordernodes(nh);

 /* triangulate_byquadtree(nh,th);*/
}
