/* PUGQUAD.C  Quadtree based routines */


#include "pug.h"


/* A macro to decide if a point lies within a quad or not */
#define withinquad(N,SX,SY,EX,EY) \
        ((N)->ex>=(SX) && (N)->ey>=(SY) && (N)->ex<=(EX) && (N)->ey<=(EY))


nodelist *newnodelist(n)
	 node *n;
{
  nodelist *nl;

  nl = (nodelist *)malloc(sizeof(nodelist));
  if(nl==NULL) {
	fprintf(stderr,"Out of memory. Sorry.\n");
	exit(1);
  }
  
  nl->n = n;
  nl->next = NULL;
  nl->c1 = nl->c2 = NULL;

  return(nl);
}


/* Removes the first node encountered with the given
   exactdouble coordinates from the list and returns
   a pointer to it */
node *extractnode(nl,ex,ey)
	 nodelist **nl;
	 exactdouble ex,ey;
{
  double x,y;
  node *n;
  nodelist *prev,*curr;

  if(*nl==NULL) return(NULL);

  prev = NULL;
  curr = *nl;

  x = ExactDouble2DoubleX(ex);
  y = ExactDouble2DoubleY(ey);

  while(curr!=NULL) {
	n = curr->n;

	if(DoubleEQ(n->x,x) && DoubleEQ(n->y,y)) {

	  if(prev==NULL) *nl = (*nl)->next;
	  else prev->next = curr->next;

	  free(curr);
	  return(n);
	}

	prev = curr;
	curr = curr->next;
  }

  return(NULL);
}


/* Searches the list for a node with the given double coordinates */
node *findnode(nlh,x,y)
	 nodelist *nlh;
	 double x,y;
{
  nodelist *nl;

  nl = nlh;
  while(nl!=NULL) {
	if(DoubleEQ(nl->n->x,x) && DoubleEQ(nl->n->y,y))
	  return(nl->n);
	nl = nl->next;
  }

  return(NULL);
}


/* Divides up the given node list into four parts, one for each
   of the indicated children. Appropriately duplicates nodes
   found that should be in more than 1 list. Does not destroy
   the original nodelist */
void divynodelist(nlhead,nlul,nlur,nlbr,nlbl,sx,sy,ex,ey,mx,my) 
	 nodelist *nlhead,**nlul,**nlur,**nlbr,**nlbl;
	 exactdouble sx,sy,ex,ey,mx,my;
{
  node *n;
  nodelist *nl,*nltemp;

  nl = nlhead;
  while(nl!=NULL) {
	n = nl->n;

	if(withinquad(n,sx,sy,mx,my)) {
	  nltemp = newnodelist(n);
	  nltemp->next = *nlbl;
	  *nlbl = nltemp;
	}
	if(withinquad(n,sx,my,mx,ey)) {
	  nltemp = newnodelist(n);
	  nltemp->next = *nlul;
	  *nlul = nltemp;
	}
	if(withinquad(n,mx,my,ex,ey)) {
	  nltemp = newnodelist(n);
	  nltemp->next = *nlur;
	  *nlur = nltemp;
	}
	if(withinquad(n,mx,sy,ex,my)) {
	  nltemp = newnodelist(n);
	  nltemp->next = *nlbr;
	  *nlbr = nltemp;
	}

	nl = nl->next;
  }
}


/* Deletes a nodelist */
void freenodelist(nl)
	 nodelist *nl;
{
  nodelist *nlnext;

  if(nl==NULL) return;

  while(nl!=NULL) {
	nlnext = nl->next;

	free(nl);
	nl = nlnext;
  }
}

void shownlist(nl)
	 nodelist *nl;
{
  while(nl!=NULL) {
	printf("Node: (%lf,%lf) %c\n",nl->n->x,nl->n->y,((nl->n->flags)&FLAG_Created) ? 'C' : 'R');	
	nl = nl->next;
  }
}
