/* PUGOUT.C   Output routines to display grid after calculations finished */

#include "pug.h"


/* 3-D Rotation initial values */
double alphayz = PI/8.0;
double alphayx = PI/8.0;
double alphaxz = 0.0;


/* 3-D Rotation step value */
double alphastep = PI/16.0;

/* Displays the solved grids */
void showgrids(nh,th,argc,argv)
	 node *nh;
	 triangle *th;
	 int argc;
	 char *argv[];
{

  /* dump(nh,th); */

  /*showxgrids(argc,argv,nh,th);*/
  dump(nh,th);
}

/* Change rotation factor in (y,z) plane */
void rotateyz(a)
	 double a;
{
  alphayz += a;
}

/* Change rotation factor in (y,x) plane */
void rotateyx(a)
	 double a;
{
  alphayx += a;
}

/* Change rotation factor in (x,z) plane */
void rotatexz(a)
	 double a;
{
  alphaxz += a;
}

void flatten()
{
  alphayz = PI/2.0;
  alphayx = 0.0;
  alphaxz = 0.0;
}


/* Converts 3-D coords into their 2-D projection onto the output
   window. Input is (x,y,z), and output is (a,b), which is the 
   projection onto the (x,0,z) plane */
void make2d(x,y,z,a,b)
	 double x,y,z,*a,*b;
{
  double h,theta;

  /* First rotate (x,y,z) in (y,z) plane */
  h = hypot(y,z);
  if(y==0.0) theta = (PI/2.0) + alphayz;
  else theta = atan(z/y) + alphayz;
  
  z = h*sin(theta);
  y = h*cos(theta);

  /* And then rotate (x,y,z) in (y,x) plane */
  h=hypot(y,x);
  if(y==0.0) theta = (PI/2.0) + alphayx;
  else theta=atan2(x,y) + alphayx;

  x = h*sin(theta);
  y = h*cos(theta);

  /* And then rotate (x,y,z) in (x,z) plane */
  h=hypot(x,z);
  if(x==0.0) theta = (PI/2.0) + alphaxz;
  else theta=atan2(z,x) + alphaxz;

  z = h*sin(theta);
  x = h*cos(theta);


  /* Now project (x,y,z) onto the (x,z) plane (window) and convert
	 to [0,1] coordinates */

  *a = x;
  *b = z;
}

int dump(nh,th)
	 node *nh;
	 triangle *th;
{
  int i,tcorn;
  node *n;
  triangle *t;

  printf("Dumping...\n");

  n=nh;  i=0;
  while(n!=NULL) {

	i++;
	printf("[%03d] Node (%g,%g) {",i,n->ac,n->acon);
	t=n->thead;
	while(t!=NULL) {
	   printf("%d%s",t->processor,(t!=n->ttail) ? "," : "");
	   tcorn=WhichCorner(t,n);
	   t=t->c[tcorn].next;
	}
	printf("}\n");

	n=n->next;
  }
/*
  t=th;  i=0;
  while(t!=NULL) {

	i++;
	printf("[%d] Triangle %d: ((%g,%g),(%g,%g),(%g,%g))\n",i,
	  t->processor,
	  t->c[0].a[0],t->c[0].a[1],
	  t->c[1].a[0],t->c[1].a[1],
	  t->c[2].a[0],t->c[2].a[1]);
	t=t->next;
  }
  */
  printf("---------\n\n");
}
