/* PUGPURGE.C  Routines to remove unwanted triangles resulting from 
               Watson's Delaunay Triangulation algorithm */


#include "pug.h"


int outsideregion(/* node *nh; triangle *t; */);



/* Removes triangles that lie outside the given polygonal boundary */
void purgetriangles(nh,th)
	 node *nh;
	 triangle **th;
{
  triangle *t,*tnext;

  printf("Purging...");

  t = *th; 
  while(t!=NULL) {

	tnext=t->next;

	if(outsideregion(nh,t)) {
	  printf("  purged: (%g,%g,%g)\n",
			 (t->c[0].n)->x,(t->c[0].n)->y,
			 (t->c[1].n)->x,(t->c[1].n)->y,
			 (t->c[2].n)->x,(t->c[2].n)->y);
	  unmake_triangle(th,t);
	}

	t=tnext;
  }
  printf("..purged.\n");
}


/* Responds with True if t is considered outside the bounding polygon
   defined by nodes headed by nh */
int outsideregion(nh,t)
	 node *nh;
	 triangle *t;
{
  int i,s1,s2,s3,s4,wrap;
  double cx,cy;
  node *n1,*n2,*n3,l1,l2;

  /* Locate centroid of triangle */
  l1.x = ((t->c[0].n)->x + (t->c[1].n)->x + (t->c[2].n)->x) / 3.0;
  l1.y = ((t->c[0].n)->y + (t->c[1].n)->y + (t->c[2].n)->y) / 3.0;

  /* And now the point (-BigNumber,cy) */
  l2.x = -BigNumber;
  l2.y = l1.y;

  /* Now determine how many times the half-ray
	 ((cx,cy),(-BigNumber,cy)) intersects the boundary of the
	 polygon */
  i=0; wrap=False;
  n1=nh;
  while(!wrap) {

	if(n1->next==NULL || !((n1->next->flags)&FLAG_RealBoundary)) {
	  n2 = nh;
	  wrap = True;
	} else
	  n2 = n1->next;

	/* Determine whether (n1,n2) intersects (l1,l2) */
	s1=sarea(&l1,&l2,n1);	s2=sarea(&l1,&l2,n2);
	s3=sarea(n1,n2,&l1); s4=sarea(n1,n2,&l2);

	/* First test for simple (non-degenerate) intersection */
	if(s1!=Sarea_None && s2!=Sarea_None && 
	   s3!=Sarea_None && s4!=Sarea_None &&
	   s1!=s2 && s3!=s4) i++;

	/* Now test for case where n2 lies on (l1,l2) */
	else if(s1!=Sarea_None && s3!=Sarea_None && 
			s2==Sarea_None && s4!=Sarea_None &&
			s3!=s4) {

	  /* Locate next n2 that does not lie on (l1,l2) */
	  while(s2==Sarea_None && n2!=n1) {

		if(n2->next==NULL || !((n2->next->flags)&FLAG_RealBoundary)) {		
		  n2=nh;
		  wrap=True;
		} else 
		  n2=n2->next;
		s2=sarea(&l1,&l1,n2);
	  }

	  if(s1!=s2) i++;
	  
	}
			
	n1=n2;
  }
  
  /* Finally, an even number of intersections indicates that
	 the triangle is outside the polygon, and an odd number
	 indicates that the triangle is inside the polygon */
  return(!(i%2));
}


