/* PUGQUADOP.C  Quadtree operations */


#include "pug.h"


/* Rotates the collection of nodes counter-clockwise by 90 degrees */
void rotatecounterclockwise(nul,nur,nbr,nbl,nt,nr,nb,nl)
	 node **nul,**nur,**nbr,**nbl,**nt,**nr,**nb,**nl;
{
  node *ntemp;

  ntemp = *nul;
  *nul = *nur;
  *nur = *nbr;
  *nbr = *nbl;
  *nbl = ntemp;

  ntemp = *nt;
  *nt = *nr;
  *nr = *nb;
  *nb = *nl;
  *nl = ntemp;
}


/* Rotates the collection of nodes clockwise by 90 degrees */
void rotateclockwise(nul,nur,nbr,nbl,nt,nr,nb,nl)
	 node **nul,**nur,**nbr,**nbl,**nt,**nr,**nb,**nl;
{
  node *ntemp;

  ntemp = *nul;
  *nul = *nbl;
  *nbl = *nbr;
  *nbr = *nur;
  *nur = ntemp;

  ntemp = *nt;
  *nt = *nl;
  *nl = *nb;
  *nb = *nr;
  *nr = ntemp;
}


/* Flips the square about its horizontal bisector */
void reflectvertically(nul,nur,nbr,nbl,nt,nr,nb,nl)
	 node **nul,**nur,**nbr,**nbl,**nt,**nr,**nb,**nl;
{
  node *ntemp;
  double midy;

  ntemp = *nul; *nul = *nbl; *nbl = ntemp;
  ntemp = *nur; *nur = *nbr; *nbr = ntemp;
  ntemp = *nb; *nb = *nt; *nt = ntemp;
}


/* Flips the square about its vertical bisector */
void reflecthorizontally(nul,nur,nbr,nbl,nt,nr,nb,nl)
	 node **nul,**nur,**nbr,**nbl,**nt,**nr,**nb,**nl;
{
  node *ntemp;
  double midx;

  ntemp = *nul; *nul = *nur; *nur = ntemp;
  ntemp = *nbl; *nbl = *nbr; *nbr = ntemp;
  ntemp = *nl; *nl = *nr; *nr = ntemp;
}
