/* PUGREORDER.C  Reorders nodes in linked list so they're roughly ordered by distance from
   the border */

#include "pug.h"


void marknodes(/* node *nh,*nstop; int flagmask; */);
void shownodes(/* node *nh; int flagmask; */);


/* Reorders the nodes in the linked list by increasing minimum distance
   from the border. */
void reordernodes(nh)
	 node **nh;
{
  node **nhead,*ntail,*n;

  ntail=shiftnodes(nh,FLAG_RealBoundary);
  nhead=nh;

  while(ntail!=NULL) {

	marknodes(*nhead,ntail->next,FLAG_Mark);

	nhead = &(ntail->next);
	ntail = shiftnodes(nhead,FLAG_Mark);
  }
}


/* Runs through the list of nodes, ORing the flags field with flagmask
   for all nodes connected to any node from nh .. nstop-1
   (well, it's a linked list so nstop-1 doesn't really make sense,
   but you get the idea) */
void marknodes(nh,nstop,flagmask)
	 node *nh,*nstop;
	 int flagmask;
{
  int tcorn;
  node *n;
  triangle *t;

  n=nh;
  while(n!=nstop) {

	t=n->thead;
	while(t!=NULL) {

	  tcorn=WhichCorner(t,n);

	  (t->c[(tcorn+1)%3].n)->flags |= flagmask;
	  (t->c[(tcorn+2)%3].n)->flags |= flagmask;
	
	  t=t->c[tcorn].next;
	}

	n=n->next;
  }	
}



void shownodes(s,nh,flagmask)
	 char *s;
	 node *nh;
	 int flagmask;
{
  node *n;

  printf(s);
  n=nh;
  while(n!=NULL) {
	if((n->flags)&flagmask) printf("*");
	else printf(".");

	n=n->next;
  }
  printf("\n");
}


/* Shifts all nodes with a specified flags mask to the beginning of the
   node list. Returns a pointer to the last node in the list that
   matches the flag mask (or NULL if none do). Maintains relative order
   of shifted nodes */
node *shiftnodes(nh,flagmask)
	 node **nh;
	 int flagmask;
{
  node *n,*nhead,*ntail,*nlast,*nextn;

  /* These 2 define the front & back of the nodes matching flagmask */
  nhead=NULL; ntail=NULL;

  /* And nlast is a trailing pointer */
  nlast=NULL; n= *nh;
  while(n!=NULL) {

	if((n->flags)&flagmask) {

	  nextn=n->next;

	  /* Delete from old list */
	  if(nlast==NULL) *nh = n->next;
	  else nlast->next=n->next;

	  /* Insert into end of new list */
	  if(ntail==NULL) nhead=n;
	  else ntail->next=n;

	  ntail=n;		
	  n->next=NULL;

	  /* And move on to next node */
	  n=nextn;

	} else {

	  nlast=n;
	  n=n->next;

	}	  
  }

  /* Now to stitch the 2 lists back together */
  if(ntail==NULL) return(NULL); 

  ntail->next= *nh;
  *nh = nhead;

  return(ntail);
}
